/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import se.sjobeck.datastructures.TlgStruct;
import se.sjobeck.datastructures.kalkylering.ProjektInfo;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.datastructures.kalkylering.TillaggsKategori;
import se.sjobeck.gui.CheckBoxList;
import se.sjobeck.gui.HidingCheckBoxList;
import se.sjobeck.gui.MyCellRenderer;

public class HidingTlgTab
extends JTabbedPane {
    protected JList[] lists;
    private boolean blocker = true;
    protected JList allaValda;
    private JScrollPane allaValdaScrollPane;
    protected JList bredsp;
    protected JList btg;
    protected JList fonster;
    protected JList hindertlg;
    protected JList hojdtlg;
    private JScrollPane jScrollPane10;
    private JScrollPane jScrollPane11;
    private JScrollPane jScrollPane12;
    private JScrollPane jScrollPane13;
    private JScrollPane jScrollPane14;
    private JScrollPane jScrollPane15;
    private JScrollPane jScrollPane16;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane7;
    private JScrollPane jScrollPane8;
    private JScrollPane jScrollPane9;
    protected JList rumtlg;
    protected JList snickeri;
    protected JList stal;
    protected JList strykning;
    protected JList stuck;
    protected JList tapet;
    protected JList tra;
    protected JList vav;

    private JList getList(TillaggsKategori typ) {
        switch (typ) {
            case Golv: {
                return this.rumtlg;
            }
            case H\u00f6jd: {
                return this.hojdtlg;
            }
            case Hinder: {
                return this.hindertlg;
            }
            case Bredspackling: {
                return this.bredsp;
            }
            case Stuckatur: {
                return this.stuck;
            }
            case Tapet: {
                return this.tapet;
            }
            case V\u00e4v: {
                return this.vav;
            }
            case Strykning: {
                return this.strykning;
            }
            case Snickeri: {
                return this.snickeri;
            }
            case F\u00f6nster: {
                return this.fonster;
            }
            case Tr\u00e4konstruktioner: {
                return this.tra;
            }
            case Betongkonstruktioner: {
                return this.btg;
            }
            case St\u00e5lPl\u00e5t: {
                return this.stal;
            }
        }
        throw new IllegalArgumentException("Trasig till\u00e4gs-typ!");
    }

    public HidingTlgTab() {
        this.initComponents();
        for (JList jl : this.lists = new JList[]{this.rumtlg, this.hindertlg, this.hojdtlg, this.stuck, this.tapet, this.strykning, this.bredsp, this.fonster, this.snickeri, this.btg, this.tra, this.stal, this.vav}) {
            jl.setCellRenderer(new MyCellRenderer());
        }
        this.allaValda.setCellRenderer(new MyCellRenderer());
    }

    public void configure(RadStruct rad, TlgStruct[] selected, ProjektInfo currentProject) {
        for (TillaggsKategori kat : TillaggsKategori.values()) {
            try {
                this.configureTlgList(kat, currentProject);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        for (TillaggsKategori kat : currentProject.getDatabaseInstance().getTill\u00e4ggsKategorier(rad)) {
            try {
                JList list = this.getList(kat);
                list.setEnabled(true);
                if (kat == TillaggsKategori.Hinder) {
                    list.setEnabled(false);
                }
                list.setListData(currentProject.getDatabaseInstance().getTill\u00e4ggsTabell().get(kat.stringReference()).toArray());
                for (TlgStruct tlg : selected) {
                    for (int i = list.getModel().getSize() - 1; i >= 0; --i) {
                        if (!list.getModel().getElementAt(i).equals(tlg)) continue;
                        list.addSelectionInterval(i, i);
                    }
                }
                HidingCheckBoxList cbList = (HidingCheckBoxList)list;
                HidingCheckBoxList.setInomhus(rad.getInomhus());
                HidingCheckBoxList.setUtomhus(!rad.getInomhus());
            }
            catch (IllegalArgumentException e) {}
        }
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            boolean enabled = ((JScrollPane)this.getComponentAt(i)).getViewport().getView().isEnabled();
            this.setEnabledAt(i, enabled);
            if (!enabled) continue;
            this.setSelectedIndex(i);
        }
        this.buildAllSelectedTab();
        this.setSelectedComponent(this.allaValdaScrollPane);
    }

    private void configureTlgList(TillaggsKategori kat, ProjektInfo currentProject) {
        JList list = this.getList(kat);
        list.setListData(currentProject.getDatabaseInstance().getTill\u00e4ggsTabell().get(kat.stringReference()).toArray());
        list.clearSelection();
        list.setEnabled(false);
    }

    public TlgStruct[] getTlg() {
        TlgStruct[] ret = new TlgStruct[this.totalLength()];
        int mark = 0;
        for (int i = 0; i < this.lists.length; ++i) {
            System.arraycopy(this.lists[i].getSelectedValues(), 0, ret, mark, this.lists[i].getSelectedIndices().length);
            mark += this.lists[i].getSelectedIndices().length;
        }
        return ret;
    }

    private int totalLength() {
        int ret = 0;
        for (int i = 0; i < this.lists.length; ++i) {
            if (this.lists[i].getSelectedIndices() == null) continue;
            ret += this.lists[i].getSelectedIndices().length;
        }
        return ret;
    }

    public void addListSelectionListener(ListSelectionListener x) {
        for (int i = 0; i < this.lists.length; ++i) {
            this.lists[i].addListSelectionListener(x);
        }
    }

    public synchronized void setTlg(TlgStruct[] tlg) {
        for (int i = 0; i < this.lists.length; ++i) {
            this.lists[i].clearSelection();
            for (int j = 0; j < tlg.length; ++j) {
                this.lists[i].setSelectedValue(tlg[j], false);
            }
        }
    }

    public synchronized void addTlg(TlgStruct[] tlg) {
        for (int i = 0; i < this.lists.length; ++i) {
            for (int j = 0; j < tlg.length; ++j) {
                this.lists[i].setSelectedValue(tlg[j], false);
            }
        }
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.rumtlg = new HidingCheckBoxList();
        this.jScrollPane4 = new JScrollPane();
        this.hojdtlg = new HidingCheckBoxList();
        this.jScrollPane3 = new JScrollPane();
        this.hindertlg = new HidingCheckBoxList();
        this.jScrollPane10 = new JScrollPane();
        this.bredsp = new HidingCheckBoxList();
        this.jScrollPane7 = new JScrollPane();
        this.stuck = new HidingCheckBoxList();
        this.jScrollPane8 = new JScrollPane();
        this.tapet = new HidingCheckBoxList();
        this.jScrollPane16 = new JScrollPane();
        this.vav = new HidingCheckBoxList();
        this.jScrollPane9 = new JScrollPane();
        this.strykning = new HidingCheckBoxList();
        this.jScrollPane12 = new JScrollPane();
        this.snickeri = new HidingCheckBoxList();
        this.jScrollPane11 = new JScrollPane();
        this.fonster = new HidingCheckBoxList();
        this.jScrollPane14 = new JScrollPane();
        this.tra = new HidingCheckBoxList();
        this.jScrollPane13 = new JScrollPane();
        this.btg = new HidingCheckBoxList();
        this.jScrollPane15 = new JScrollPane();
        this.stal = new HidingCheckBoxList();
        this.allaValdaScrollPane = new JScrollPane();
        this.allaValda = new CheckBoxList();
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                HidingTlgTab.this.stateChangedListener(evt);
            }
        });
        this.jScrollPane2.setName("Golv");
        this.jScrollPane2.setViewportView(this.rumtlg);
        this.addTab("Golv", this.jScrollPane2);
        this.jScrollPane4.setName("H\u00f6jd");
        this.jScrollPane4.setViewportView(this.hojdtlg);
        this.addTab("H\u00f6jd", this.jScrollPane4);
        this.jScrollPane3.setName("Hinder");
        this.jScrollPane3.setViewportView(this.hindertlg);
        this.addTab("Hinder", this.jScrollPane3);
        this.jScrollPane10.setName("Bredsp.");
        this.jScrollPane10.setViewportView(this.bredsp);
        this.addTab("Bredsp.", this.jScrollPane10);
        this.jScrollPane7.setName("Stuck");
        this.jScrollPane7.setViewportView(this.stuck);
        this.addTab("Stuck", this.jScrollPane7);
        this.jScrollPane8.setName("Tapet");
        this.jScrollPane8.setViewportView(this.tapet);
        this.addTab("Tapet", this.jScrollPane8);
        this.jScrollPane16.setName("V\u00e4v");
        this.jScrollPane16.setViewportView(this.vav);
        this.addTab("V\u00e4v", this.jScrollPane16);
        this.jScrollPane9.setName("Strykning");
        this.jScrollPane9.setViewportView(this.strykning);
        this.addTab("Strykning", this.jScrollPane9);
        this.jScrollPane12.setName("Snickeri");
        this.jScrollPane12.setViewportView(this.snickeri);
        this.addTab("Snickeri", this.jScrollPane12);
        this.jScrollPane11.setName("F\u00f6nster");
        this.jScrollPane11.setViewportView(this.fonster);
        this.addTab("F\u00f6nster", this.jScrollPane11);
        this.jScrollPane14.setName("Tr\u00e4 konstr.");
        this.jScrollPane14.setViewportView(this.tra);
        this.addTab("Tr\u00e4 konstr.", this.jScrollPane14);
        this.jScrollPane13.setName("Btg. konstr.");
        this.jScrollPane13.setViewportView(this.btg);
        this.addTab("Btg. konstr.", this.jScrollPane13);
        this.jScrollPane15.setName("St\u00e5l/pl\u00e5t");
        this.jScrollPane15.setViewportView(this.stal);
        this.addTab("St\u00e5l/pl\u00e5t", this.jScrollPane15);
        this.allaValdaScrollPane.setName("Alla valda till\u00e4gg");
        this.allaValda.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                HidingTlgTab.this.allaValdaValueChanged(evt);
            }
        });
        this.allaValdaScrollPane.setViewportView(this.allaValda);
        this.addTab("Alla valda till\u00e4gg", this.allaValdaScrollPane);
    }

    private void allaValdaValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting() && !this.blocker) {
            Object[] data = this.allaValda.getSelectedValues();
            TlgStruct[] list = new TlgStruct[data.length];
            System.arraycopy(data, 0, list, 0, data.length);
            this.setTlg(list);
        }
    }

    public void buildAllSelectedTab() {
        TlgStruct[] list = this.getTlg();
        this.allaValda.setListData(list);
        this.allaValda.setSelectionInterval(0, list.length - 1);
    }

    private void stateChangedListener(ChangeEvent evt) {
        if (((JTabbedPane)evt.getSource()).getSelectedComponent() == null) {
            return;
        }
        if (((JTabbedPane)evt.getSource()).getSelectedComponent().equals(this.allaValdaScrollPane)) {
            this.buildAllSelectedTab();
            this.blocker = false;
        } else {
            this.blocker = true;
        }
    }
}

