/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import se.sjobeck.datastructures.EditableRadTable;
import se.sjobeck.datastructures.KalkylNod;
import se.sjobeck.datastructures.ProjectManager;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.gui.AckumuleratTableCellRenderer;
import se.sjobeck.gui.AmaKodPanel;
import se.sjobeck.gui.AntalEditor;
import se.sjobeck.gui.ByggdelDescriptionEditor;
import se.sjobeck.gui.ByggdelPanel;
import se.sjobeck.gui.ColorPanel;
import se.sjobeck.gui.DimensionListEditor;
import se.sjobeck.gui.KalkylGUI;
import se.sjobeck.gui.PopupEditor;
import se.sjobeck.gui.TidEditor;
import se.sjobeck.gui.TillaggPanel;
import se.sjobeck.gui.YtproduktEditor;
import se.sjobeck.gui.multilinetable2.MultilineAwareRowHeader;
import se.sjobeck.gui.multilinetable2.RowHeaderDragListener;

public class Ackumulerat
extends JPanel
implements CellEditorListener {
    public static final EventObject extendedEditingEventObject = new EventObject(Ackumulerat.class);
    private EditableRadTable radModel;
    private KalkylGUI gui;
    private ProjectManager projectManager;
    private static TableCellEditor[] cellEditors = new TableCellEditor[9];
    protected JScrollPane jScrollPane1;
    protected JTable jTable1;

    public String getEnhet(RadStruct struct) {
        return this.radModel.getEnhet(struct);
    }

    public Ackumulerat(final KalkylGUI gui, ProjectManager manager, boolean reduced, boolean editable) {
        this.gui = gui;
        this.projectManager = manager;
        this.initComponents();
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        this.setModel(new EditableRadTable(reduced, null));
        if (editable) {
            this.setupEditors();
        }
        this.radModel.setEditable(editable);
        this.jTable1.setAutoCreateColumnsFromModel(false);
        this.jTable1.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiersEx() & 0x80) == 128) {
                    Ackumulerat.this.radModel.sortByColumn(-1);
                } else {
                    Ackumulerat.this.radModel.sortByColumn(Ackumulerat.this.jTable1.getColumnModel().getColumnIndexAtX(e.getX()));
                }
                Ackumulerat.this.jTable1.getTableHeader().repaint();
            }
        });
        MultilineAwareRowHeader rowHead = new MultilineAwareRowHeader(this.jTable1);
        this.jScrollPane1.setRowHeaderView(rowHead);
        RowHeaderDragListener drag = new RowHeaderDragListener(rowHead){

            @Override
            public void reorder(int index1, int index2) {
                Ackumulerat.this.radModel.reorder(index1, index2);
            }
        };
        rowHead.addMouseListener(drag);
        rowHead.addMouseMotionListener(drag);
        final TableCellRenderer defaultHeader = this.jTable1.getTableHeader().getDefaultRenderer();
        this.jTable1.getTableHeader().setDefaultRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel c = (JLabel)defaultHeader.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (column == Ackumulerat.this.radModel.getSortingColumn()) {
                    c.setFont(c.getFont().deriveFont(1));
                } else {
                    c.setFont(c.getFont().deriveFont(0));
                }
                return c;
            }
        });
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        final Preferences AckumuleratPrefs = Preferences.userNodeForPackage(this.getClass());
        this.jTable1.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                for (int i = 0; i < Ackumulerat.this.jTable1.getColumnCount(); ++i) {
                    TableColumn col = Ackumulerat.this.jTable1.getColumnModel().getColumn(i);
                    AckumuleratPrefs.putInt("ackKolumn" + i, col.getWidth());
                }
            }
        });
        AckumuleratPrefs.addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                int colIndex;
                if (evt.getKey().startsWith("ackKolumn") && (colIndex = Integer.parseInt(evt.getKey().substring(9))) < Ackumulerat.this.jTable1.getColumnCount()) {
                    TableColumn col = Ackumulerat.this.jTable1.getColumnModel().getColumn(colIndex);
                    col.setPreferredWidth(Integer.parseInt(evt.getNewValue()));
                }
            }
        });
        InputMap im = this.jTable1.getInputMap(1);
        ActionMap am = this.jTable1.getActionMap();
        AbstractAction changeRowOrTabAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int sr = Ackumulerat.this.jTable1.getSelectedRow();
                int sc = Ackumulerat.this.jTable1.getSelectedColumn() + 1;
                for (int y = sr; y < Ackumulerat.this.jTable1.getRowCount(); ++y) {
                    for (int x = sc; x < Ackumulerat.this.jTable1.getColumnCount(); ++x) {
                        if (!Ackumulerat.this.jTable1.getModel().isCellEditable(y, x)) continue;
                        if (Ackumulerat.this.jTable1.getCellEditor() != null) {
                            Ackumulerat.this.jTable1.getCellEditor().stopCellEditing();
                        }
                        Ackumulerat.this.jTable1.changeSelection(y, x, false, false);
                        return;
                    }
                    sc = 0;
                }
                sr = 0;
                if (Ackumulerat.this.jTable1.getCellEditor() != null) {
                    Ackumulerat.this.jTable1.getCellEditor().stopCellEditing();
                }
            }
        };
        im.put(KeyStroke.getKeyStroke("pressed ENTER"), "bytRadOmKolumnSjuAnnarsTab");
        am.put("bytRadOmKolumnSjuAnnarsTab", changeRowOrTabAction);
        im.put(KeyStroke.getKeyStroke("shift pressed ENTER"), im.get(KeyStroke.getKeyStroke("shift pressed TAB")));
        im.put(KeyStroke.getKeyStroke("pressed F2"), "startExtendedEditing");
        AbstractAction extendedEditingAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Ackumulerat.this.jTable1.editCellAt(Ackumulerat.this.jTable1.getSelectedRow(), Ackumulerat.this.jTable1.getSelectedColumn(), extendedEditingEventObject);
                if (Ackumulerat.this.jTable1.getCellEditor() instanceof PopupEditor) {
                    ((PopupEditor)Ackumulerat.this.jTable1.getCellEditor()).showDialog();
                }
            }
        };
        am.put("startExtendedEditing", extendedEditingAction);
        im.put(KeyStroke.getKeyStroke("control pressed H"), "openFetchRowDialog");
        AbstractAction openFetchRowDialog = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (gui != null) {
                    gui.pushButton("fetchRowButton");
                }
            }
        };
        am.put("openFetchRowDialog", openFetchRowDialog);
    }

    public Action getExtendedEditingAction() {
        ActionMap am = this.jTable1.getActionMap();
        return am.get("startExtendedEditing");
    }

    public void setModel(EditableRadTable newModel) {
        this.radModel = newModel;
        this.jTable1.setModel(this.radModel);
        this.radModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                Ackumulerat.this.jTable1.getTableHeader().repaint();
                switch (e.getType()) {
                    case -1: 
                    case 1: {
                        Ackumulerat.this.jTable1.setRowSelectionInterval(e.getFirstRow(), e.getFirstRow());
                    }
                }
            }
        });
        AckumuleratTableCellRenderer leftRenderer = new AckumuleratTableCellRenderer(this.radModel);
        AckumuleratTableCellRenderer rightRenderer = new AckumuleratTableCellRenderer(this.radModel, 2);
        AckumuleratTableCellRenderer centerRenderer = new AckumuleratTableCellRenderer(this.radModel, 1);
        TableColumnModel cModel = this.jTable1.getColumnModel();
        cModel.getColumn(0).setCellRenderer(leftRenderer);
        cModel.getColumn(1).setCellRenderer(leftRenderer);
        cModel.getColumn(2).setCellRenderer(leftRenderer);
        cModel.getColumn(3).setCellRenderer(leftRenderer);
        cModel.getColumn(4).setCellRenderer(leftRenderer);
        cModel.getColumn(5).setCellRenderer(leftRenderer);
        cModel.getColumn(6).setCellRenderer(leftRenderer);
        if (!this.radModel.isReduced()) {
            cModel.getColumn(7).setCellRenderer(rightRenderer);
            cModel.getColumn(8).setCellRenderer(rightRenderer);
            cModel.getColumn(9).setCellRenderer(rightRenderer);
            cModel.getColumn(10).setCellRenderer(rightRenderer);
            cModel.getColumn(11).setCellRenderer(rightRenderer);
            cModel.getColumn(12).setCellRenderer(rightRenderer);
            cModel.getColumn(13).setCellRenderer(rightRenderer);
            cModel.getColumn(14).setCellRenderer(rightRenderer);
            cModel.getColumn(15).setCellRenderer(rightRenderer);
            cModel.getColumn(16).setCellRenderer(rightRenderer);
            cModel.getColumn(17).setCellRenderer(rightRenderer);
        } else {
            cModel.getColumn(7).setCellRenderer(centerRenderer);
        }
        Preferences AckumuleratPrefs = Preferences.userNodeForPackage(this.getClass());
        for (int i = 0; i < this.jTable1.getColumnCount(); ++i) {
            TableColumn col = this.jTable1.getColumnModel().getColumn(i);
            col.setPreferredWidth(AckumuleratPrefs.getInt("ackKolumn" + i, 100));
        }
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        int x_cur = this.jTable1.getSelectedColumn();
        int y_cur = this.jTable1.getSelectedRow();
        if (x_cur < 0 || x_cur >= this.jTable1.getColumnCount()) {
            return;
        }
        if (y_cur < 0 || y_cur >= this.jTable1.getRowCount()) {
            return;
        }
        if (++x_cur > 7) {
            x_cur = 0;
            ++y_cur;
        }
        if (y_cur > this.jTable1.getRowCount() - 1) {
            y_cur = 0;
        }
        this.jTable1.changeSelection(y_cur, x_cur, false, false);
    }

    private void setupEditors() {
        TableCellEditor cellEditor = this.buildEditor(0);
        cellEditor.addCellEditorListener(this);
        this.jTable1.getColumnModel().getColumn(0).setCellEditor(cellEditor);
        cellEditor = this.buildEditor(1);
        cellEditor.addCellEditorListener(this);
        this.jTable1.getColumnModel().getColumn(1).setCellEditor(cellEditor);
        cellEditor = this.buildEditor(2);
        cellEditor.addCellEditorListener(this);
        this.jTable1.getColumnModel().getColumn(2).setCellEditor(cellEditor);
        cellEditor = this.buildEditor(3);
        cellEditor.addCellEditorListener(this);
        this.jTable1.getColumnModel().getColumn(3).setCellEditor(cellEditor);
        cellEditor = this.buildEditor(4);
        cellEditor.addCellEditorListener(this);
        this.jTable1.getColumnModel().getColumn(4).setCellEditor(cellEditor);
        cellEditor = this.buildEditor(5);
        cellEditor.addCellEditorListener(this);
        this.jTable1.getColumnModel().getColumn(5).setCellEditor(cellEditor);
        cellEditor = this.buildEditor(6);
        cellEditor.addCellEditorListener(this);
        this.jTable1.getColumnModel().getColumn(6).setCellEditor(cellEditor);
        cellEditor = this.buildEditor(7);
        cellEditor.addCellEditorListener(this);
        this.jTable1.getColumnModel().getColumn(7).setCellEditor(cellEditor);
        if (!this.radModel.isReduced()) {
            cellEditor = this.buildEditor(8);
            cellEditor.addCellEditorListener(this);
            this.jTable1.getColumnModel().getColumn(10).setCellEditor(cellEditor);
        }
    }

    private TableCellEditor buildEditor(int column) {
        if (cellEditors[column] == null) {
            Serializable editor = null;
            switch (column) {
                case 0: {
                    editor = new PopupEditor(this.gui, new ByggdelPanel());
                    break;
                }
                case 1: {
                    editor = new PopupEditor(this.gui, new ByggdelDescriptionEditor(this.projectManager));
                    break;
                }
                case 2: {
                    editor = new PopupEditor(this.gui, new DimensionListEditor(this.gui, this.projectManager));
                    break;
                }
                case 3: {
                    editor = new PopupEditor(this.gui, new AmaKodPanel(this.projectManager));
                    break;
                }
                case 4: {
                    editor = new PopupEditor(this.gui, new TillaggPanel(this.projectManager));
                    break;
                }
                case 5: {
                    editor = new PopupEditor(this.gui, new YtproduktEditor(this.projectManager));
                    break;
                }
                case 6: {
                    editor = new PopupEditor(this.gui, new ColorPanel(this.projectManager));
                    break;
                }
                case 7: {
                    editor = new PopupEditor(this.gui, new AntalEditor(this.projectManager));
                    break;
                }
                case 8: {
                    editor = new TidEditor();
                }
            }
            Ackumulerat.cellEditors[column] = editor;
        }
        return cellEditors[column];
    }

    @Override
    public void grabFocus() {
        if (this.jTable1.getSelectedRow() == -1) {
            this.jTable1.setRowSelectionInterval(0, 0);
        }
        if (this.jTable1.getSelectedColumn() == -1) {
            this.jTable1.setColumnSelectionInterval(0, 0);
        }
        this.jTable1.grabFocus();
    }

    public int getSelectedRowCount() {
        return this.jTable1.getSelectedRowCount();
    }

    public void deleteSelected() {
        int[] rows = this.jTable1.getSelectedRows();
        if (this.jTable1.isEditing()) {
            this.jTable1.getCellEditor().cancelCellEditing();
        }
        for (int i = rows.length - 1; i >= 0; --i) {
            try {
                this.radModel.deleteRow(rows[i]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public void addRow(RadStruct b) {
        int row = this.jTable1.getSelectedRow();
        if (row >= 0 && row != this.jTable1.getRowCount() - 1) {
            this.radModel.addRowAt(b, row);
        } else {
            this.radModel.addRow(b);
        }
    }

    public void appendRows(RadStruct[] rs) {
        if (rs.length != 0) {
            this.radModel.appendRows(rs);
        }
    }

    public void setDefault() {
        int which = this.jTable1.getSelectedRow();
        if (which != -1 && which != this.jTable1.getRowCount() - 1) {
            this.projectManager.getCurrentProject().setDefaultRow(this.radModel.getRad(which));
        }
    }

    public void insertRow() {
        this.addRow(this.projectManager.getCurrentProject().getDefaultRow());
    }

    public RadStruct[] getSelectedRows() {
        int[] indices = this.jTable1.getSelectedRows();
        RadStruct[] ret = new RadStruct[indices.length];
        for (int arrayIndex = 0; arrayIndex < indices.length; ++arrayIndex) {
            ret[arrayIndex] = this.radModel.getRad(indices[arrayIndex]);
        }
        return ret;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable(){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                return Ackumulerat.this.radModel.getToolTipText(rowIndex, colIndex);
            }
        };
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setAutoscrolls(true);
        this.jTable1.setAutoResizeMode(0);
        this.jTable1.setIntercellSpacing(new Dimension(0, 0));
        this.jTable1.setShowHorizontalLines(false);
        this.jTable1.setShowVerticalLines(false);
        this.jTable1.setSurrendersFocusOnKeystroke(true);
        this.jScrollPane1.setViewportView(this.jTable1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    void setNode(KalkylNod kalkylNod) {
        this.radModel.setCurrentNode(kalkylNod);
    }
}

