/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures.drawings;

import java.io.File;
import se.sjobeck.datastructures.drawings.FromGeometraDrawing;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFBlueprint;
import se.sjobeck.geometra.datastructures.blueprint.PDFController;
import se.sjobeck.geometra.datastructures.blueprint.PDFLoader;
import se.sjobeck.util.pdf.file_network_tracking.PDFTracker;

class PDFViewContainerTracker {
    private static PDFViewContainerTracker vct;
    private static transient boolean onlyOnce;
    private static final transient int MaxLoadedPDFs = 5;
    private final int[] mostRecentPdf = new int[5];
    private final IcePDFBlueprint[] pdfVec = new IcePDFBlueprint[5];
    private transient PDFController pdfController = null;

    private PDFViewContainerTracker() {
        assert (onlyOnce);
        onlyOnce = false;
        for (int i = 0; i < 5; ++i) {
            this.mostRecentPdf[i] = i;
        }
    }

    static PDFViewContainerTracker getPDFViewContainerTrackerInstance() {
        if (vct == null) {
            vct = new PDFViewContainerTracker();
        }
        return vct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IcePDFBlueprint loadIcePdfblueprint(FromGeometraDrawing fgd) {
        IcePDFBlueprint ib = this.seeIfItAllreadyLoaded(fgd);
        if (ib != null) {
            return ib;
        }
        ib = this.load(fgd);
        if (ib != null) {
            return ib;
        }
        Object object = fgd.protectDIP;
        synchronized (object) {
            if (!fgd.downloadingInProgress) {
                PDFTracker pdftracker = PDFTracker.getPDFTracker();
                fgd.setDIP_if_DIP_not_true(true);
                pdftracker.tryDownloadPDF(fgd.getPdfName(), fgd.getProjectName(), fgd);
            }
        }
        return null;
    }

    private IcePDFBlueprint seeIfItAllreadyLoaded(FromGeometraDrawing fgd) {
        String filepath = fgd.getPDFFilePath();
        IcePDFBlueprint ib = null;
        for (int i = 0; i < 5; ++i) {
            if (this.pdfVec[i] == null || !this.pdfVec[i].getPDFFilepath().equalsIgnoreCase(filepath)) continue;
            ib = this.pdfVec[i];
            this.updateTracker(i);
        }
        return ib;
    }

    private void updateTracker(int pos) {
        for (int j = 0; j < 5; ++j) {
            this.mostRecentPdf[j] = this.mostRecentPdf[j] - 1;
        }
        this.mostRecentPdf[pos] = 5;
    }

    private IcePDFBlueprint load(FromGeometraDrawing fgd) {
        File pdfFile = new File(fgd.getPDFFilePath());
        if (pdfFile.exists()) {
            IcePDFBlueprint loadPDF = PDFLoader.loadPDF(pdfFile);
            int pos = this.findLowest();
            if (this.pdfVec[pos] != null) {
                this.unload(this.pdfVec[pos]);
            }
            this.pdfVec[pos] = loadPDF;
            this.updateTracker(pos);
            return loadPDF;
        }
        return null;
    }

    private void unload(IcePDFBlueprint ib) {
        PDFController pDFController = ib.getPDFController();
        pDFController.disableMenu();
        pDFController.dispose();
    }

    private int findLowest() {
        int lowest = 5;
        int pos = 0;
        for (int i = 0; i < 5; ++i) {
            if (this.mostRecentPdf[i] >= lowest) continue;
            lowest = this.mostRecentPdf[i];
            pos = i;
        }
        return pos;
    }

    static {
        onlyOnce = true;
    }
}

