/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.datastructures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import se.sjobeck.datastructures.Projekt;
import se.sjobeck.datastructures.kalkylering.Behandling;
import se.sjobeck.datastructures.kalkylering.BehandlingsTyp;
import se.sjobeck.datastructures.kalkylering.RadStruct;
import se.sjobeck.parser2.Function;

public abstract class KalkylNod
extends DefaultMutableTreeNode {
    protected static List<RadStruct> tom = Collections.emptyList();
    public static KalkylNod nullValue = new KalkylNod(){

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public boolean deletable() {
            return true;
        }

        @Override
        public List<RadStruct> getRader() {
            return tom;
        }

        @Override
        public List<RadStruct> getPrintableRader() {
            List<RadStruct> megatom = Collections.emptyList();
            return this.okToPrint ? tom : megatom;
        }

        @Override
        public KalkylNod copy() {
            return nullValue;
        }

        @Override
        public double golvYta() {
            return 0.0;
        }

        @Override
        public double getAntal() {
            return 0.0;
        }
    };
    protected String beskrivning;
    protected transient double antal;
    protected String antalFormel;
    public boolean okToPrint = true;

    public abstract double golvYta();

    public abstract double getAntal();

    public String getEnhet(RadStruct struct) {
        if (struct.getDim().getEnh() != null && !struct.getDim().get_Text().startsWith("Enl")) {
            return struct.getDim().getEnh();
        }
        if (struct.getBehKod() != null) {
            return this.getProject().getCustomEnhet(struct.getBehKod());
        }
        Behandling behandling = this.getProject().getDatabaseInstance().getBehandling(BehandlingsTyp.F\u00e4rdigbehandling, struct);
        if (behandling != null) {
            return behandling.getEnhet();
        }
        return "";
    }

    KalkylNod() {
    }

    KalkylNod(KalkylNod n) {
        this.beskrivning = n.beskrivning;
        this.antalFormel = n.antalFormel;
    }

    @Override
    public String toString() {
        return this.getBeskrivning();
    }

    @Override
    public void setUserObject(Object obj) {
        this.setBeskrivning(obj.toString());
    }

    public void setAntal(String newFormel) {
        this.antalFormel = newFormel;
        this.update(this);
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    public void setBeskrivning(String desc) {
        this.beskrivning = desc;
        this.update(this);
    }

    public String getPathName() {
        TreeNode parent1 = this.getParent();
        if (parent1 != null) {
            KalkylNod p = (KalkylNod)this.parent;
            if (this.beskrivning.equals("Total")) {
                return this.beskrivning;
            }
            return p.getPathName() + "\\" + this.beskrivning;
        }
        return this.getProject().getFileReference().getName() + "\\" + this.beskrivning;
    }

    public String getBeskrivning() {
        return this.beskrivning;
    }

    protected List<Function> getKonstanter() {
        if (this.parent != null) {
            return ((KalkylNod)this.parent).getKonstanter();
        }
        return new ArrayList<Function>();
    }

    public String getAntalFormel() {
        return this.antalFormel;
    }

    public void update() {
        this.update(this);
    }

    public void update(KalkylNod nod) {
        ((KalkylNod)this.parent).update(nod);
    }

    public Projekt getProject() {
        if (this.parent != null) {
            return ((KalkylNod)this.parent).getProject();
        }
        return null;
    }

    @Override
    public abstract boolean isLeaf();

    public abstract boolean deletable();

    public abstract List<RadStruct> getRader();

    public abstract List<RadStruct> getPrintableRader();

    public abstract KalkylNod copy();

    public boolean getOkToPrint() {
        return this.okToPrint;
    }

    public void setOkToPrint(boolean newValue) {
        this.okToPrint = newValue;
        if (!this.isLeaf()) {
            Enumeration<TreeNode> children1 = this.children();
            for (Object kn : this.children) {
                ((KalkylNod)kn).setOkToPrint(newValue);
            }
        }
    }

    public void toggleOkToPrint() {
        this.setOkToPrint(!this.okToPrint);
    }
}

