/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.annotations.PopupAnnotation;
import org.icepdf.ri.common.tools.TextAnnotationHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.icepdf.ri.common.views.AnnotationComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;
import org.icepdf.ri.common.views.annotations.PopupAnnotationComponent;
import org.icepdf.ri.common.views.annotations.TextAnnotationComponent;

public abstract class MarkupAnnotationComponent
extends AbstractAnnotationComponent {
    private static final Logger logger = Logger.getLogger(TextAnnotationComponent.class.toString());
    protected MarkupAnnotation markupAnnotation;

    public MarkupAnnotationComponent(Annotation annotation, DocumentViewController documentViewController, AbstractPageViewComponent pageViewComponent, DocumentViewModel documentViewModel) {
        super(annotation, documentViewController, pageViewComponent, documentViewModel);
        if (annotation instanceof MarkupAnnotation) {
            this.markupAnnotation = (MarkupAnnotation)annotation;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (e.getClickCount() == 2 && this.markupAnnotation != null) {
            PopupAnnotation popup = this.markupAnnotation.getPopupAnnotation();
            if (popup != null) {
                popup.setOpen(!popup.isOpen());
                ArrayList<AnnotationComponent> annotationComponents = this.pageViewComponent.getAnnotationComponents();
                Reference popupReference = popup.getPObjectReference();
                for (AnnotationComponent annotationComponent : annotationComponents) {
                    Reference compReference = annotationComponent.getAnnotation().getPObjectReference();
                    if (!compReference.equals(popupReference)) continue;
                    if (!(annotationComponent instanceof PopupAnnotationComponent)) break;
                    PopupAnnotationComponent popupComponent = (PopupAnnotationComponent)annotationComponent;
                    popupComponent.setVisible(popup.isOpen());
                    Rectangle popupBounds = popupComponent.getBounds();
                    Rectangle pageBounds = this.pageViewComponent.getBounds();
                    if (!pageBounds.contains(popupBounds.getX(), popupBounds.getY(), popupBounds.getWidth(), popupBounds.getHeight())) {
                        int x = popupBounds.x;
                        int y = popupBounds.y;
                        if (x + popupBounds.width > pageBounds.width) {
                            x -= popupBounds.width - (pageBounds.width - popupBounds.x);
                        }
                        if (y + popupBounds.height > pageBounds.height) {
                            y -= popupBounds.height - (pageBounds.height - popupBounds.y);
                        }
                        popupBounds.setLocation(x, y);
                        popupComponent.setBounds(popupBounds);
                    }
                    break;
                }
            } else {
                Rectangle bounds = this.getBounds();
                Rectangle bBox = new Rectangle(bounds.x, bounds.y, 215, 150);
                Rectangle tBbox = this.convertToPageSpace(bBox).getBounds();
                if (this.markupAnnotation != null) {
                    this.markupAnnotation.setCreationDate(PDate.formatDateTime(new Date()));
                    this.markupAnnotation.setTitleText(System.getProperty("user.name"));
                    this.markupAnnotation.setContents("");
                }
                PopupAnnotation annotation = TextAnnotationHandler.createPopupAnnotation(this.documentViewModel.getDocument().getPageTree().getLibrary(), tBbox, this.markupAnnotation, this.getPageTransform());
                AbstractAnnotationComponent comp = AnnotationComponentFactory.buildAnnotationComponent(annotation, this.documentViewController, this.pageViewComponent, this.documentViewModel);
                comp.setBounds(bBox);
                comp.refreshAnnotationRect();
                if (this.documentViewController.getAnnotationCallback() != null) {
                    AnnotationCallback annotationCallback = this.documentViewController.getAnnotationCallback();
                    annotationCallback.newAnnotation(this.pageViewComponent, comp);
                }
                this.pageViewComponent.revalidate();
            }
        }
    }

    protected Shape convertToPageSpace(Shape shape) {
        Page currentPage = this.pageViewComponent.getPage();
        AffineTransform at = currentPage.getPageTransform(this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            logger.log(Level.FINE, "Error converting to page space.", e);
        }
        shape = at.createTransformedShape(shape);
        return shape;
    }
}

