/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views.annotations;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import org.icepdf.ri.util.jxlayer.JXLayer;
import org.icepdf.ri.util.jxlayer.plaf.LayerUI;

public class FreeTextArea
extends JTextArea {
    private ZoomProvider zoomProvider;
    private boolean active;

    public FreeTextArea(ZoomProvider zoomProvider) {
        this.zoomProvider = zoomProvider;
        this.getDocument().putProperty("i18n", Boolean.TRUE.toString());
        this.putClientProperty("i18n", Boolean.TRUE.toString());
        LayerUI<JComponent> layerUI = new LayerUI<JComponent>(){

            @Override
            public void installUI(JComponent c) {
                super.installUI(c);
                ((JXLayer)c).setLayerEventMask(48L);
            }

            @Override
            public void uninstallUI(JComponent c) {
                super.uninstallUI(c);
                ((JXLayer)c).setLayerEventMask(0L);
            }

            @Override
            public void eventDispatched(AWTEvent ae, JXLayer<? extends JComponent> l) {
                MouseEvent e = (MouseEvent)ae;
                float zoom = FreeTextArea.this.zoomProvider.getZoom();
                MouseEvent newEvent = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), (int)((float)e.getX() / zoom), (int)((float)e.getY() / zoom), e.getClickCount(), e.isPopupTrigger(), e.getButton());
                e.consume();
                FreeTextArea.this.processMouseEvent(newEvent);
                FreeTextArea.this.processMouseMotionEvent(newEvent);
            }
        };
        new JXLayer<JComponent>(this, layerUI);
    }

    @Override
    protected void paintBorder(Graphics g) {
        if (!this.active) {
            return;
        }
        super.paintBorder(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.active) {
            return;
        }
        float zoom = this.zoomProvider.getZoom();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        AffineTransform old = g2.getTransform();
        g2.scale(zoom, zoom);
        super.paintComponent(g2);
        g2.setTransform(old);
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
        super.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public static interface ZoomProvider {
        public float getZoom();
    }
}

