/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.views;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.icepdf.ri.common.CurrentPageChanger;
import org.icepdf.ri.common.KeyListenerPageColumnChanger;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModelImpl;
import org.icepdf.ri.common.views.PageViewComponent;
import org.icepdf.ri.common.views.PageViewDecorator;

public class TwoColumnPageView
extends AbstractDocumentView {
    protected JScrollPane documentScrollpane;
    protected boolean disposing;
    protected JPanel pagesPanel;
    protected int viewAlignment;
    protected CurrentPageChanger currentPageChanger;
    protected KeyListenerPageColumnChanger keyListenerPageChanger;

    public TwoColumnPageView(DocumentViewController documentDocumentViewController, JScrollPane documentScrollpane, DocumentViewModelImpl documentViewModel, int viewAlignment) {
        super(documentDocumentViewController, documentScrollpane, documentViewModel);
        this.documentScrollpane = documentScrollpane;
        this.viewAlignment = viewAlignment;
        this.buildGUI();
        this.currentPageChanger = new CurrentPageChanger(documentScrollpane, this, documentViewModel.getPageComponents());
        if (this.documentViewController.getParentController() instanceof SwingController) {
            this.keyListenerPageChanger = KeyListenerPageColumnChanger.install((SwingController)this.documentViewController.getParentController(), this.documentScrollpane, this, this.currentPageChanger);
        }
    }

    private void buildGUI() {
        this.pagesPanel = new JPanel();
        this.pagesPanel.setBackground(backgroundColor);
        GridLayout gridLayout = new GridLayout(0, 2, horizontalSpace, verticalSpace);
        this.pagesPanel.setLayout(gridLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(layoutInserts, layoutInserts, layoutInserts, layoutInserts);
        gbc.gridwidth = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.pagesPanel, gbc);
        List<AbstractPageViewComponent> pageComponents = this.documentViewModel.getPageComponents();
        if (pageComponents != null) {
            int max = pageComponents.size();
            int max2 = pageComponents.size();
            for (int i = 0; i < max && i < max2; ++i) {
                PageViewComponent pageViewComponent;
                if (i == 0 && max2 > 2 && this.viewAlignment == 1) {
                    this.pagesPanel.add(new JLabel());
                }
                if ((pageViewComponent = (PageViewComponent)pageComponents.get(i)) == null) continue;
                pageViewComponent.setDocumentViewCallback(this);
                this.pagesPanel.add(new PageViewDecorator((AbstractPageViewComponent)pageViewComponent));
            }
        }
    }

    @Override
    public void updateDocumentView() {
    }

    @Override
    public int getNextPageIncrement() {
        return 2;
    }

    @Override
    public int getPreviousPageIncrement() {
        return 2;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.currentPageChanger.mouseReleased(e);
    }

    @Override
    public void dispose() {
        this.disposing = true;
        if (this.currentPageChanger != null) {
            this.currentPageChanger.dispose();
        }
        if (this.keyListenerPageChanger != null) {
            this.keyListenerPageChanger.uninstall();
        }
        this.pagesPanel.removeAll();
        this.pagesPanel.invalidate();
        super.dispose();
    }

    @Override
    public Dimension getDocumentSize() {
        float pageViewWidth = 0.0f;
        float pageViewHeight = 0.0f;
        if (this.pagesPanel != null) {
            int currPageIndex;
            int currCompIndex;
            int numComponents = this.pagesPanel.getComponentCount();
            boolean foundCurrent = false;
            for (currCompIndex = currPageIndex = this.documentViewController.getCurrentPageIndex(); currCompIndex >= 0 && currCompIndex < numComponents; ++currCompIndex) {
                PageViewDecorator pvd;
                PageViewComponent pvc;
                Component comp = this.pagesPanel.getComponent(currCompIndex);
                if (!(comp instanceof PageViewDecorator) || (pvc = (pvd = (PageViewDecorator)comp).getPageViewComponent()).getPageIndex() != currPageIndex) continue;
                Dimension dim = pvd.getPreferredSize();
                pageViewWidth = dim.width;
                pageViewHeight = dim.height;
                foundCurrent = true;
                break;
            }
            if (foundCurrent) {
                Component comp;
                int otherCompIndex;
                boolean evenPageIndex = (currPageIndex & 1) == 0;
                boolean bumpedIndex = currCompIndex != currPageIndex;
                boolean onLeft = evenPageIndex ^ bumpedIndex;
                int n = otherCompIndex = onLeft ? currCompIndex + 1 : currCompIndex - 1;
                if (otherCompIndex >= 0 && otherCompIndex < numComponents && (comp = this.pagesPanel.getComponent(otherCompIndex)) instanceof PageViewDecorator) {
                    PageViewDecorator pvd = (PageViewDecorator)comp;
                    Dimension dim = pvd.getPreferredSize();
                    pageViewWidth = dim.width;
                    pageViewHeight = dim.height;
                }
            }
        }
        float currentZoom = this.documentViewModel.getViewZoom();
        pageViewWidth = Math.abs(pageViewWidth / currentZoom);
        pageViewHeight = Math.abs(pageViewHeight / currentZoom);
        pageViewWidth *= 2.0f;
        return new Dimension((int)(pageViewWidth += (float)(AbstractDocumentView.horizontalSpace * 4)), (int)(pageViewHeight += (float)(AbstractDocumentView.verticalSpace * 2)));
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle clipBounds = g.getClipBounds();
        g.setColor(backgroundColor);
        g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        super.paintComponent(g);
    }
}

