/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import org.icepdf.core.pobjects.NameTree;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.utility.annotation.NameJTree;
import org.icepdf.ri.common.utility.annotation.NameTreeNode;

public class NameTreeDialog
extends JDialog
implements ActionListener,
TreeSelectionListener {
    private SwingController controller;
    private ResourceBundle messageBundle;
    private JTree nameJTree;
    private NameTreeNode selectedName;
    private JLabel destinationName;
    private JButton okButton;
    private JButton cancelButton;
    private GridBagConstraints constraints;

    public NameTreeDialog(SwingController controller, boolean modal, NameTree nameTree) throws HeadlessException {
        super((Frame)controller.getViewerFrame(), modal);
        this.controller = controller;
        this.messageBundle = this.controller.getMessageBundle();
        this.setGui(nameTree);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.selectedName != null) {
                this.destinationName.setText(((Object)this.selectedName.getName()).toString());
            }
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.nameJTree.getLastSelectedPathComponent() != null) {
            NameTreeNode selectedNode = (NameTreeNode)this.nameJTree.getLastSelectedPathComponent();
            if (selectedNode.getReference() != null) {
                this.selectedName = selectedNode;
            } else {
                this.nameJTree.setSelectionPath(null);
                this.selectedName = null;
            }
        }
    }

    private void setGui(NameTree nameTree) {
        this.setTitle(this.messageBundle.getString("viewer.utilityPane.action.dialog.goto.nameTree.title"));
        this.nameJTree = new NameJTree();
        this.nameJTree.setModel(new DefaultTreeModel(new NameTreeNode(nameTree.getRoot(), this.messageBundle)));
        this.nameJTree.setRootVisible(!nameTree.getRoot().isEmpty());
        this.nameJTree.addTreeSelectionListener(this);
        JScrollPane nameTreeScroller = new JScrollPane(this.nameJTree);
        nameTreeScroller.setPreferredSize(new Dimension(325, 225));
        this.okButton = new JButton(this.messageBundle.getString("viewer.button.ok.label"));
        this.okButton.setMnemonic(this.messageBundle.getString("viewer.button.ok.mnemonic").charAt(0));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(this.messageBundle.getString("viewer.button.cancel.label"));
        this.cancelButton.setMnemonic(this.messageBundle.getString("viewer.button.cancel.mnemonic").charAt(0));
        this.cancelButton.addActionListener(this);
        JPanel okCancelPanel = new JPanel(new FlowLayout());
        okCancelPanel.add(this.okButton);
        okCancelPanel.add(this.cancelButton);
        JPanel nameTreePanel = new JPanel();
        nameTreePanel.setAlignmentY(0.0f);
        GridBagLayout layout = new GridBagLayout();
        nameTreePanel.setLayout(layout);
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 0;
        this.constraints.weightx = 1.0;
        this.constraints.anchor = 11;
        this.constraints.anchor = 13;
        this.constraints.insets = new Insets(5, 5, 5, 5);
        this.constraints.anchor = 10;
        this.addGB(nameTreePanel, nameTreeScroller, 0, 0, 1, 1);
        this.addGB(nameTreePanel, okCancelPanel, 0, 1, 1, 1);
        this.getContentPane().add(nameTreePanel);
        this.setSize(new Dimension(375, 350));
        this.validate();
        this.setLocationRelativeTo(this.controller.getViewerFrame());
    }

    public void setDestinationName(JLabel destinationName) {
        this.destinationName = destinationName;
    }

    @Override
    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NameTreeDialog.this.setVisible(false);
                NameTreeDialog.this.dispose();
            }
        };
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(actionListener, stroke, 2);
        return rootPane;
    }

    private void addGB(JPanel layout, Component component, int x, int y, int rowSpan, int colSpan) {
        this.constraints.gridx = x;
        this.constraints.gridy = y;
        this.constraints.gridwidth = rowSpan;
        this.constraints.gridheight = colSpan;
        layout.add(component, this.constraints);
    }
}

