/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.utility.annotation;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.annotations.LineAnnotation;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.utility.annotation.AnnotationPanelAdapter;
import org.icepdf.ri.common.utility.annotation.ValueLabelItem;
import org.icepdf.ri.common.views.AnnotationComponent;

public class LineAnnotationPanel
extends AnnotationPanelAdapter
implements ItemListener,
ActionListener {
    private static final int DEFAULT_START_END_TYPE = 0;
    private static final int DEFAULT_END_END_TYPE = 0;
    private static final int DEFAULT_LINE_THICKNESS = 0;
    private static final int DEFAULT_LINE_STYLE = 0;
    private static final Color DEFAULT_BORDER_COLOR = Color.DARK_GRAY;
    private static final Color DEFAULT_FILL_COLOR = Color.DARK_GRAY;
    private static ValueLabelItem[] END_TYPE_LIST;
    private JComboBox startEndTypeBox;
    private JComboBox endEndTypeBox;
    private JComboBox lineThicknessBox;
    private JComboBox lineStyleBox;
    private JButton colorButton;
    private JButton internalColorButton;
    private LineAnnotation annotation;

    public LineAnnotationPanel(SwingController controller) {
        super(controller);
        this.setLayout(new GridLayout(6, 2, 5, 2));
        this.setFocusable(true);
        this.createGUI();
        this.setEnabled(false);
        this.revalidate();
    }

    @Override
    public void setAnnotationComponent(AnnotationComponent newAnnotation) {
        if (newAnnotation == null || newAnnotation.getAnnotation() == null) {
            this.setEnabled(false);
            return;
        }
        this.currentAnnotationComponent = newAnnotation;
        this.annotation = (LineAnnotation)this.currentAnnotationComponent.getAnnotation();
        this.applySelectedValue(this.startEndTypeBox, this.annotation.getStartArrow());
        this.applySelectedValue(this.endEndTypeBox, this.annotation.getEndArrow());
        this.applySelectedValue(this.lineThicknessBox, Float.valueOf(this.annotation.getLineThickness()));
        this.applySelectedValue(this.lineStyleBox, this.annotation.getLineStyle());
        this.colorButton.setBackground(this.annotation.getColor());
        this.internalColorButton.setBackground(this.annotation.getInteriorColor());
        this.safeEnable(this.startEndTypeBox, true);
        this.safeEnable(this.endEndTypeBox, true);
        this.safeEnable(this.lineThicknessBox, true);
        this.safeEnable(this.lineStyleBox, true);
        this.safeEnable(this.colorButton, true);
        this.safeEnable(this.internalColorButton, true);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ValueLabelItem item = (ValueLabelItem)e.getItem();
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.startEndTypeBox) {
                this.annotation.setStartArrow((Name)item.getValue());
            } else if (e.getSource() == this.endEndTypeBox) {
                this.annotation.setEndArrow((Name)item.getValue());
            } else if (e.getSource() == this.lineThicknessBox) {
                this.annotation.getBorderStyle().setStrokeWidth(((Float)item.getValue()).floatValue());
            } else if (e.getSource() == this.lineStyleBox) {
                this.annotation.getBorderStyle().setBorderStyle((Name)item.getValue());
            }
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.resetAppearanceShapes();
            this.currentAnnotationComponent.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color chosenColor;
        if (e.getSource() == this.colorButton) {
            Color chosenColor2 = JColorChooser.showDialog(this.colorButton, this.messageBundle.getString("viewer.utilityPane.annotation.line.colorChooserTitle"), this.colorButton.getBackground());
            if (chosenColor2 != null) {
                this.colorButton.setBackground(chosenColor2);
                this.annotation.setColor(chosenColor2);
                this.updateCurrentAnnotation();
                this.currentAnnotationComponent.resetAppearanceShapes();
                this.currentAnnotationComponent.repaint();
            }
        } else if (e.getSource() == this.internalColorButton && (chosenColor = JColorChooser.showDialog(this.internalColorButton, this.messageBundle.getString("viewer.utilityPane.annotation.line.colorInternalChooserTitle"), this.internalColorButton.getBackground())) != null) {
            this.internalColorButton.setBackground(chosenColor);
            this.annotation.setInteriorColor(chosenColor);
            this.updateCurrentAnnotation();
            this.currentAnnotationComponent.resetAppearanceShapes();
            this.currentAnnotationComponent.repaint();
        }
    }

    private void createGUI() {
        if (END_TYPE_LIST == null) {
            END_TYPE_LIST = new ValueLabelItem[]{new ValueLabelItem(LineAnnotation.LINE_END_NONE, this.messageBundle.getString("viewer.utilityPane.annotation.line.end.none")), new ValueLabelItem(LineAnnotation.LINE_END_OPEN_ARROW, this.messageBundle.getString("viewer.utilityPane.annotation.line.end.openArrow")), new ValueLabelItem(LineAnnotation.LINE_END_CLOSED_ARROW, this.messageBundle.getString("viewer.utilityPane.annotation.line.end.closedArrow")), new ValueLabelItem(LineAnnotation.LINE_END_DIAMOND, this.messageBundle.getString("viewer.utilityPane.annotation.line.end.diamond")), new ValueLabelItem(LineAnnotation.LINE_END_SQUARE, this.messageBundle.getString("viewer.utilityPane.annotation.line.end.square")), new ValueLabelItem(LineAnnotation.LINE_END_CIRCLE, this.messageBundle.getString("viewer.utilityPane.annotation.line.end.circle"))};
        }
        this.setBorder(new TitledBorder(new EtchedBorder(1), this.messageBundle.getString("viewer.utilityPane.annotation.line.appearance.title"), 1, 0));
        this.startEndTypeBox = new JComboBox<ValueLabelItem>(END_TYPE_LIST);
        this.startEndTypeBox.setSelectedIndex(0);
        this.startEndTypeBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.line.startStyle")));
        this.add(this.startEndTypeBox);
        this.endEndTypeBox = new JComboBox<ValueLabelItem>(END_TYPE_LIST);
        this.endEndTypeBox.setSelectedIndex(0);
        this.endEndTypeBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.line.endStyle")));
        this.add(this.endEndTypeBox);
        this.lineThicknessBox = new JComboBox<ValueLabelItem>(LINE_THICKNESS_LIST);
        this.lineThicknessBox.setSelectedIndex(0);
        this.lineThicknessBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.line.lineThickness")));
        this.add(this.lineThicknessBox);
        this.lineStyleBox = new JComboBox<ValueLabelItem>(LINE_STYLE_LIST);
        this.lineStyleBox.setSelectedIndex(0);
        this.lineStyleBox.addItemListener(this);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.line.lineStyle")));
        this.add(this.lineStyleBox);
        this.colorButton = new JButton();
        this.colorButton.addActionListener(this);
        this.colorButton.setOpaque(true);
        this.colorButton.setBackground(DEFAULT_BORDER_COLOR);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.line.colorLabel")));
        this.add(this.colorButton);
        this.internalColorButton = new JButton();
        this.internalColorButton.addActionListener(this);
        this.internalColorButton.setOpaque(true);
        this.internalColorButton.setBackground(DEFAULT_FILL_COLOR);
        this.add(new JLabel(this.messageBundle.getString("viewer.utilityPane.annotation.line.colorInternalLabel")));
        this.add(this.internalColorButton);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.safeEnable(this.startEndTypeBox, enabled);
        this.safeEnable(this.endEndTypeBox, enabled);
        this.safeEnable(this.lineThicknessBox, enabled);
        this.safeEnable(this.lineStyleBox, enabled);
        this.safeEnable(this.colorButton, enabled);
        this.safeEnable(this.internalColorButton, enabled);
    }

    protected boolean safeEnable(JComponent comp, boolean enabled) {
        if (comp != null) {
            comp.setEnabled(enabled);
            return true;
        }
        return false;
    }

    private void applySelectedValue(JComboBox comboBox, Object value) {
        comboBox.removeItemListener(this);
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            ValueLabelItem currentItem = (ValueLabelItem)comboBox.getItemAt(i);
            if (!currentItem.getValue().equals(value)) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
        comboBox.addItemListener(this);
    }
}

