/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;

public class ZoomOutPageHandler
implements ToolHandler {
    private static final Logger logger = Logger.getLogger(ZoomOutPageHandler.class.toString());
    private AbstractPageViewComponent pageViewComponent;
    private DocumentViewController documentViewController;
    private DocumentViewModel documentViewModel;

    public ZoomOutPageHandler(DocumentViewController documentViewController, AbstractPageViewComponent pageViewComponent, DocumentViewModel documentViewModel) {
        this.documentViewController = documentViewController;
        this.pageViewComponent = pageViewComponent;
        this.documentViewModel = documentViewModel;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if ((e.getModifiers() & 0x1F5) != 0 && (e.getModifiers() & 0x10) != 0) {
            Point pageOffset = this.documentViewModel.getPageBounds(this.pageViewComponent.getPageIndex()).getLocation();
            Point mouse = e.getPoint();
            mouse.setLocation(pageOffset.x + mouse.x, pageOffset.y + mouse.y);
            this.documentViewController.setZoomOut(mouse);
        }
        if (this.pageViewComponent != null) {
            this.pageViewComponent.requestFocus();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void paintTool(Graphics g) {
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }
}

