/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.Adjustable;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;

public class PanningHandler
implements ToolHandler {
    private Point lastMousePosition = new Point();
    private DocumentViewController documentViewController;
    private DocumentViewModel documentViewModel;
    private AbstractDocumentView parentComponent;

    public PanningHandler(DocumentViewController documentViewController, DocumentViewModel documentViewModel, AbstractDocumentView parentComponent) {
        this.documentViewController = documentViewController;
        this.documentViewModel = documentViewModel;
        this.parentComponent = parentComponent;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.documentViewController != null) {
            Adjustable verticalScrollbar = this.documentViewController.getVerticalScrollBar();
            Adjustable horizontalScrollbar = this.documentViewController.getHorizontalScrollBar();
            if (verticalScrollbar != null && horizontalScrollbar != null) {
                Point p = new Point((int)e.getPoint().getX() - horizontalScrollbar.getValue(), (int)e.getPoint().getY() - verticalScrollbar.getValue());
                int x = (int)((double)horizontalScrollbar.getValue() - (p.getX() - this.lastMousePosition.getX()));
                int y = (int)((double)verticalScrollbar.getValue() - (p.getY() - this.lastMousePosition.getY()));
                horizontalScrollbar.setValue(x);
                verticalScrollbar.setValue(y);
                this.lastMousePosition.setLocation(p);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.documentViewController != null) {
            Adjustable verticalScrollbar = this.documentViewController.getVerticalScrollBar();
            Adjustable horizontalScrollbar = this.documentViewController.getHorizontalScrollBar();
            this.lastMousePosition.setLocation(e.getPoint().getX() - (double)horizontalScrollbar.getValue(), e.getPoint().getY() - (double)verticalScrollbar.getValue());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.documentViewController.clearSelectedAnnotations();
        if (this.parentComponent != null) {
            this.parentComponent.requestFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.documentViewController != null && this.documentViewController.getDocumentViewModel().isViewToolModeSelected(1)) {
            this.documentViewController.setViewCursor(2);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.documentViewController != null && this.documentViewController.getDocumentViewModel().getViewToolMode() == 1) {
            this.documentViewController.setViewCursor(1);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void paintTool(Graphics g) {
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }
}

