/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common.tools;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AnnotationFactory;
import org.icepdf.core.pobjects.annotations.BorderStyle;
import org.icepdf.core.pobjects.annotations.InkAnnotation;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.ri.common.tools.CommonToolHandler;
import org.icepdf.ri.common.tools.LineAnnotationHandler;
import org.icepdf.ri.common.tools.ToolHandler;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.annotations.AbstractAnnotationComponent;
import org.icepdf.ri.common.views.annotations.AnnotationComponentFactory;

public class InkAnnotationHandler
extends CommonToolHandler
implements ToolHandler {
    private static final Logger logger;
    protected static BasicStroke stroke;
    protected static Color lineColor;
    protected GeneralPath inkPath;
    protected BorderStyle borderStyle = new BorderStyle();

    public InkAnnotationHandler(DocumentViewController documentViewController, AbstractPageViewComponent pageViewComponent, DocumentViewModel documentViewModel) {
        super(documentViewController, pageViewComponent, documentViewModel);
    }

    @Override
    public void paintTool(Graphics g) {
        if (this.inkPath != null) {
            Graphics2D gg = (Graphics2D)g;
            Color oldColor = gg.getColor();
            Stroke oldStroke = gg.getStroke();
            gg.setColor(lineColor);
            gg.setStroke(stroke);
            gg.draw(this.inkPath);
            gg.setColor(oldColor);
            gg.setStroke(oldStroke);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.pageViewComponent != null) {
            this.pageViewComponent.requestFocus();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.inkPath == null) {
            this.inkPath = new GeneralPath();
        }
        this.inkPath.moveTo(e.getX(), e.getY());
        this.pageViewComponent.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.inkPath.moveTo(e.getX(), e.getY());
        Rectangle bBox = this.inkPath.getBounds();
        bBox.setRect(bBox.getX() - 5.0, bBox.getY() - 5.0, bBox.getWidth() + 10.0, bBox.getHeight() + 10.0);
        Shape tInkPath = this.convertToPageSpace(this.inkPath);
        Rectangle tBbox = this.convertToPageSpace(bBox).getBounds();
        InkAnnotation annotation = (InkAnnotation)AnnotationFactory.buildAnnotation(this.documentViewModel.getDocument().getPageTree().getLibrary(), Annotation.SUBTYPE_INK, tBbox);
        annotation.setColor(lineColor);
        annotation.setBorderStyle(this.borderStyle);
        annotation.setInkPath(tInkPath);
        annotation.setBBox(tBbox);
        annotation.resetAppearanceStream(this.getPageTransform());
        AbstractAnnotationComponent comp = AnnotationComponentFactory.buildAnnotationComponent(annotation, this.documentViewController, this.pageViewComponent, this.documentViewModel);
        comp.setBounds(bBox);
        comp.refreshAnnotationRect();
        if (this.documentViewController.getAnnotationCallback() != null) {
            AnnotationCallback annotationCallback = this.documentViewController.getAnnotationCallback();
            annotationCallback.newAnnotation(this.pageViewComponent, comp);
        }
        this.documentViewController.getParentController().setDocumentToolMode(6);
        this.inkPath = null;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void installTool() {
    }

    @Override
    public void uninstallTool() {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.inkPath.lineTo(e.getX(), e.getY());
        this.pageViewComponent.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    static {
        block2: {
            logger = Logger.getLogger(LineAnnotationHandler.class.toString());
            stroke = new BasicStroke(1.0f, 0, 0, 1.0f);
            try {
                String color = Defs.sysProperty("org.icepdf.core.views.page.annotation.ink.line.color", "#00ff00");
                int colorValue = ColorUtil.convertColor(color);
                lineColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("00ff00", 16));
            }
            catch (NumberFormatException e) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.warning("Error reading Ink Annotation line colour");
            }
        }
    }
}

