/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import javax.print.DocPrintJob;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;

public class PrintJobWatcher {
    private boolean done = false;

    public PrintJobWatcher() {
    }

    public PrintJobWatcher(DocPrintJob job) {
        this.setPrintJob(job);
    }

    public void setPrintJob(DocPrintJob job) {
        job.addPrintJobListener(new PrintJobAdapter(){

            @Override
            public void printJobCanceled(PrintJobEvent printJobEvent) {
                this.allDone();
            }

            @Override
            public void printJobCompleted(PrintJobEvent printJobEvent) {
                this.allDone();
            }

            @Override
            public void printJobFailed(PrintJobEvent printJobEvent) {
                this.allDone();
            }

            @Override
            public void printJobNoMoreEvents(PrintJobEvent printJobEvent) {
                this.allDone();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void allDone() {
                PrintJobWatcher printJobWatcher = PrintJobWatcher.this;
                synchronized (printJobWatcher) {
                    PrintJobWatcher.this.done = true;
                    PrintJobWatcher.this.notify();
                }
            }
        });
    }

    public synchronized void waitForDone() {
        try {
            while (!this.done) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

