/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.icepdf.core.SecurityCallback;
import org.icepdf.core.pobjects.Document;

public class MyGUISecurityCallback
implements SecurityCallback {
    private JFrame parentFrame;
    private ResourceBundle messageBundle;

    public MyGUISecurityCallback(JFrame frame, ResourceBundle messageBundle) {
        this.parentFrame = frame;
        this.messageBundle = messageBundle;
    }

    @Override
    public String requestPassword(Document document) {
        PasswordDialog passwordDialog = new PasswordDialog(this.parentFrame);
        passwordDialog.setVisible(true);
        if (passwordDialog.isCanceled) {
            return null;
        }
        return passwordDialog.getPassword();
    }

    class PasswordDialog
    extends JDialog
    implements WindowListener {
        private GridBagConstraints constraints;
        private JPasswordField passwordField;
        private boolean isCanceled;

        public PasswordDialog(JFrame frame) {
            super((Frame)frame, true);
            this.isCanceled = false;
            this.setTitle(MyGUISecurityCallback.this.messageBundle.getString("viewer.dialog.security.title"));
            final JButton okButton = new JButton(MyGUISecurityCallback.this.messageBundle.getString("viewer.dialog.security.okButton.label"));
            okButton.setMnemonic(MyGUISecurityCallback.this.messageBundle.getString("viewer.dialog.security.okButton.mnemonic").charAt(0));
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == okButton) {
                        PasswordDialog.this.setVisible(false);
                        PasswordDialog.this.dispose();
                    }
                }
            });
            final JButton cancelButton = new JButton(MyGUISecurityCallback.this.messageBundle.getString("viewer.dialog.security.cancelButton.label"));
            cancelButton.setMnemonic(MyGUISecurityCallback.this.messageBundle.getString("viewer.dialog.security.cancelButton.mnemonic").charAt(0));
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == cancelButton) {
                        PasswordDialog.this.setVisible(false);
                        PasswordDialog.this.isCanceled = true;
                        PasswordDialog.this.dispose();
                    }
                }
            });
            this.passwordField = new JPasswordField(30);
            this.passwordField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == PasswordDialog.this.passwordField) {
                        PasswordDialog.this.setVisible(false);
                        PasswordDialog.this.dispose();
                    }
                }
            });
            JLabel msg1 = new JLabel(MyGUISecurityCallback.this.messageBundle.getString("viewer.dialog.security.msg"));
            JLabel msg2 = new JLabel(MyGUISecurityCallback.this.messageBundle.getString("viewer.dialog.security.password.label"));
            JPanel passwordPanel = new JPanel();
            passwordPanel.setAlignmentY(0.0f);
            passwordPanel.setAlignmentX(0.5f);
            GridBagLayout layout = new GridBagLayout();
            passwordPanel.setLayout(layout);
            this.getContentPane().add(passwordPanel);
            this.constraints = new GridBagConstraints();
            this.constraints.fill = 0;
            this.constraints.weightx = 1.0;
            this.constraints.anchor = 11;
            this.constraints.anchor = 17;
            this.constraints.insets = new Insets(1, 10, 1, 1);
            this.addGB(passwordPanel, msg1, 0, 0, 3, 1);
            this.addGB(passwordPanel, msg2, 0, 1, 1, 1);
            this.constraints.fill = 2;
            this.constraints.insets = new Insets(1, 10, 1, 10);
            this.addGB(passwordPanel, this.passwordField, 1, 1, 2, 1);
            this.constraints.insets = new Insets(10, 1, 1, 1);
            this.constraints.fill = 0;
            this.addGB(passwordPanel, okButton, 1, 2, 1, 1);
            this.addGB(passwordPanel, cancelButton, 2, 2, 1, 1);
            this.pack();
            this.setLocationRelativeTo(frame);
            this.setResizable(false);
            this.setSize(306, 150);
            this.addWindowListener(this);
        }

        public String getPassword() {
            return new String(this.passwordField.getPassword());
        }

        public boolean isCancelled() {
            return this.isCanceled;
        }

        private void addGB(JPanel layout, Component component, int x, int y, int colSpan, int rowSpan) {
            this.constraints.gridx = x;
            this.constraints.gridy = y;
            this.constraints.gridwidth = colSpan;
            this.constraints.gridheight = rowSpan;
            layout.add(component, this.constraints);
        }

        @Override
        public void windowClosing(WindowEvent ev) {
            this.setVisible(false);
            this.isCanceled = true;
            this.dispose();
        }

        @Override
        protected JRootPane createRootPane() {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PasswordDialog.this.setVisible(false);
                    PasswordDialog.this.isCanceled = true;
                    PasswordDialog.this.dispose();
                }
            };
            JRootPane rootPane = new JRootPane();
            KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
            rootPane.registerKeyboardAction(actionListener, stroke, 2);
            return rootPane;
        }

        @Override
        public void windowActivated(WindowEvent ev) {
        }

        @Override
        public void windowClosed(WindowEvent ev) {
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
        }

        @Override
        public void windowDeiconified(WindowEvent ev) {
        }

        @Override
        public void windowIconified(WindowEvent ev) {
        }

        @Override
        public void windowOpened(WindowEvent ev) {
        }
    }
}

