/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.icepdf.ri.common.CurrentPageChanger;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.views.AbstractDocumentView;

public class KeyListenerPageColumnChanger
extends KeyAdapter {
    private SwingController controller;
    private JScrollPane scroll;
    private AbstractDocumentView documentView;
    private CurrentPageChanger currentPageChanger;
    private boolean changingPage;

    public static KeyListenerPageColumnChanger install(SwingController c, JScrollPane s, AbstractDocumentView documentView, CurrentPageChanger currentPageChanger) {
        KeyListenerPageColumnChanger listener = null;
        if (c != null && s != null) {
            listener = new KeyListenerPageColumnChanger(c, s, documentView, currentPageChanger);
            s.addKeyListener(listener);
        }
        return listener;
    }

    public void uninstall() {
        if (this.scroll != null) {
            this.scroll.removeKeyListener(this);
        }
    }

    protected KeyListenerPageColumnChanger(SwingController c, JScrollPane s, AbstractDocumentView documentView, CurrentPageChanger currentPageChanger) {
        this.controller = c;
        this.scroll = s;
        this.documentView = documentView;
        this.changingPage = false;
        this.currentPageChanger = currentPageChanger;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.changingPage) {
            return;
        }
        int deltaPage = 0;
        int keyCode = e.getKeyCode();
        if (keyCode == 34) {
            deltaPage = this.documentView.getPreviousPageIncrement();
        } else if (keyCode == 33) {
            deltaPage = -this.documentView.getNextPageIncrement();
        } else if (keyCode == 36) {
            deltaPage = -this.controller.getCurrentPageNumber();
        } else if (keyCode == 35) {
            deltaPage = this.controller.getDocument().getNumberOfPages() - this.controller.getCurrentPageNumber() - 1;
        }
        if (deltaPage == 0) {
            return;
        }
        int newPage = this.controller.getCurrentPageNumber() + deltaPage;
        if (this.controller.getDocument() == null) {
            return;
        }
        if (newPage < 0) {
            deltaPage = -this.controller.getCurrentPageNumber();
        }
        if (newPage >= this.controller.getDocument().getNumberOfPages()) {
            deltaPage = this.controller.getDocument().getNumberOfPages() - this.controller.getCurrentPageNumber() - 1;
        }
        this.changingPage = true;
        final int dp = deltaPage;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KeyListenerPageColumnChanger.this.changingPage = false;
                KeyListenerPageColumnChanger.this.controller.goToDeltaPage(dp);
            }
        });
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (keyCode == 38 || keyCode == 40) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    KeyListenerPageColumnChanger.this.currentPageChanger.calculateCurrentPage();
                }
            });
        }
    }
}

