/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.Toolkit;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class FloatTextFieldInputVerifier
extends InputVerifier {
    private int maxLength = 6;

    public FloatTextFieldInputVerifier() {
    }

    public FloatTextFieldInputVerifier(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public boolean verify(JComponent comp) {
        boolean returnValue = true;
        JTextField textField = (JTextField)comp;
        String content = textField.getText();
        if (content.length() != 0 && content.length() < this.maxLength) {
            try {
                Float.parseFloat(textField.getText());
            }
            catch (NumberFormatException e) {
                returnValue = false;
            }
        } else if (content.length() > 0) {
            textField.setText(content.substring(0, this.maxLength));
        } else {
            textField.setText("");
        }
        return returnValue;
    }

    @Override
    public boolean shouldYieldFocus(JComponent input) {
        boolean valid = super.shouldYieldFocus(input);
        if (!valid) {
            Toolkit.getDefaultToolkit().beep();
        }
        return valid;
    }
}

