/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JScrollPane;
import org.icepdf.ri.common.MouseWheelCurrentPageListener;
import org.icepdf.ri.common.views.AbstractDocumentView;
import org.icepdf.ri.common.views.AbstractPageViewComponent;
import org.icepdf.ri.common.views.DocumentViewControllerImpl;
import org.icepdf.ri.common.views.DocumentViewModel;
import org.icepdf.ri.common.views.PageViewComponent;

public class CurrentPageChanger
extends MouseAdapter
implements AdjustmentListener {
    private static final Logger logger = Logger.getLogger(CurrentPageChanger.class.toString());
    private boolean isScrolled = false;
    private List<AbstractPageViewComponent> pageComponents;
    private JScrollPane scrollpane;
    private Object mouseWheelCurrentPageListener;
    private AbstractDocumentView documentView;
    private DocumentViewModel documentViewModel;

    public CurrentPageChanger(JScrollPane scrollpane, AbstractDocumentView documentView, List<AbstractPageViewComponent> pageComponents) {
        this(scrollpane, documentView, pageComponents, true);
    }

    public CurrentPageChanger(JScrollPane scrollpane, AbstractDocumentView documentView, List<AbstractPageViewComponent> pageComponents, boolean addWheelMouseListener) {
        this.pageComponents = pageComponents;
        this.scrollpane = scrollpane;
        this.documentView = documentView;
        this.documentViewModel = documentView.getViewModel();
        this.documentView.addMouseListener(this);
        this.scrollpane.getHorizontalScrollBar().addAdjustmentListener(this);
        this.scrollpane.getHorizontalScrollBar().addMouseListener(this);
        this.scrollpane.getVerticalScrollBar().addAdjustmentListener(this);
        this.scrollpane.getVerticalScrollBar().addMouseListener(this);
        this.mouseWheelCurrentPageListener = MouseWheelCurrentPageListener.install(scrollpane, this);
    }

    private void addMouseListenerToAnyButtonsIn(Component comp) {
        int children = comp instanceof Container ? ((Container)comp).getComponentCount() : -1;
        for (int i = 0; i < children; ++i) {
            Component kid = ((Container)comp).getComponent(i);
            if (kid instanceof AbstractButton) {
                kid.addMouseListener(this);
            }
            this.addMouseListenerToAnyButtonsIn(kid);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isScrolled) {
            this.calculateCurrentPage();
            this.isScrolled = false;
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.isScrolled = true;
    }

    public void calculateCurrentPage() {
        if (this.pageComponents != null) {
            Rectangle pageBounds;
            Rectangle viewport = this.scrollpane.getViewport().getViewRect();
            ArrayList<AbstractPageViewComponent> visiblePages = new ArrayList<AbstractPageViewComponent>(10);
            int pageCount = 0;
            for (AbstractPageViewComponent pageComponent : this.pageComponents) {
                if (pageComponent != null && (pageBounds = this.documentViewModel.getPageBounds(pageCount)) != null && pageComponent.isShowing()) {
                    visiblePages.add(pageComponent);
                }
                ++pageCount;
            }
            int x = viewport.x + viewport.width / 2;
            int y = viewport.y + viewport.height / 2;
            Point centerView = new Point(x, y);
            double minLength = Double.MAX_VALUE;
            int minPage = -1;
            for (PageViewComponent pageViewComponent : visiblePages) {
                if (pageViewComponent == null) continue;
                pageBounds = this.documentViewModel.getPageBounds(pageViewComponent.getPageIndex());
                x = pageBounds.x + pageBounds.width / 2;
                y = pageBounds.y + pageBounds.height / 2;
                double tmpDistance = centerView.distance(x, y);
                if (!(tmpDistance < minLength)) continue;
                minLength = tmpDistance;
                minPage = pageViewComponent.getPageIndex();
            }
            visiblePages.clear();
            visiblePages.trimToSize();
            int oldCurrentPage = this.documentViewModel.getViewCurrentPageIndex();
            this.documentViewModel.setViewCurrentPageIndex(minPage);
            DocumentViewControllerImpl documentViewControllerImpl = (DocumentViewControllerImpl)this.documentView.getParentViewController();
            documentViewControllerImpl.firePropertyChange("documentCurrentPage", oldCurrentPage, minPage);
        }
    }

    public void dispose() {
        this.documentView.removeMouseListener(this);
        this.scrollpane.getHorizontalScrollBar().removeAdjustmentListener(this);
        this.scrollpane.getHorizontalScrollBar().removeMouseListener(this);
        this.scrollpane.getVerticalScrollBar().removeAdjustmentListener(this);
        this.scrollpane.getVerticalScrollBar().removeMouseListener(this);
        MouseWheelCurrentPageListener.uninstall(this.scrollpane, this.mouseWheelCurrentPageListener);
    }
}

