/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.ri.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import org.icepdf.core.pobjects.Document;
import org.icepdf.ri.images.Images;

public final class AboutDialog
extends JDialog
implements ActionListener,
WindowListener {
    private JButton ok;
    private Timer timer;
    private int whichTimer;
    private static final int WAIT_TIME = 3000;
    private static final String IMAGE = "icelogo.png";
    public static final int NO_BUTTONS = 0;
    public static final int OK = 2;
    public static final int NO_TIMER = 0;
    public static final int DISAPPEAR = 4;

    public AboutDialog(Frame frame, ResourceBundle messageBundle, boolean isModal, int buttons, int whichTimer) {
        super(frame, isModal);
        int c1;
        this.whichTimer = whichTimer;
        buttons = 2;
        whichTimer = 0;
        this.setTitle(messageBundle.getString("viewer.dialog.about.title"));
        this.setResizable(false);
        JPanel panelImage = new JPanel();
        ImageIcon icon = new ImageIcon(Images.get(IMAGE));
        JLabel iconLabel = new JLabel(icon);
        iconLabel.setBorder(BorderFactory.createEmptyBorder());
        panelImage.add(iconLabel);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 1));
        panel1.add(Box.createVerticalStrut(10));
        panel1.add(panelImage);
        panel1.add(Box.createVerticalStrut(30));
        JLabel label = new JLabel(Document.getLibraryVersion());
        label.setAlignmentX(0.5f);
        panel1.add(label);
        String text = messageBundle.getString("viewer.dialog.about.pageNumber.label");
        int c2 = 0;
        while ((c1 = text.indexOf("\n", c2)) > -1) {
            panel1.add(Box.createVerticalStrut(10));
            label = new JLabel(text.substring(c2, c1));
            label.setAlignmentX(0.5f);
            panel1.add(label);
            c2 = c1 + 1;
        }
        panel1.add(Box.createVerticalStrut(10));
        label = new JLabel(text.substring(c2, text.length()));
        label.setAlignmentX(0.5f);
        panel1.add(label);
        JPanel pane = new JPanel();
        pane.setBorder(new EmptyBorder(5, 15, 5, 15));
        pane.setLayout(new BorderLayout());
        pane.add(panel1);
        if (buttons > 0) {
            JPanel panel2 = new JPanel();
            panel2.setLayout(new FlowLayout());
            if ((buttons & 2) > 0) {
                this.ok = new JButton(messageBundle.getString("viewer.button.ok.label"));
                this.ok.addActionListener(this);
                if (whichTimer > 0) {
                    this.ok.setEnabled(false);
                }
                panel2.add(this.ok);
            }
            pane.add((Component)panel2, "South");
        }
        this.setContentPane(pane);
        this.pack();
        this.setLocationRelativeTo(frame);
        if (whichTimer > 0) {
            this.timer = new Timer(3000, this);
            this.timer.start();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.timer) {
            this.timer.stop();
            if (this.whichTimer == 2) {
                this.ok.setEnabled(true);
            } else if (this.whichTimer == 4) {
                this.setVisible(false);
                this.dispose();
            }
        } else if (ev.getSource() == this.ok) {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void windowClosing(WindowEvent ev) {
        if (this.ok.isEnabled()) {
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void windowActivated(WindowEvent ev) {
    }

    @Override
    public void windowClosed(WindowEvent ev) {
    }

    @Override
    public void windowDeactivated(WindowEvent ev) {
    }

    @Override
    public void windowDeiconified(WindowEvent ev) {
    }

    @Override
    public void windowIconified(WindowEvent ev) {
    }

    @Override
    public void windowOpened(WindowEvent ev) {
    }
}

