/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.filters;

import java.io.IOException;
import java.io.InputStream;
import org.icepdf.core.pobjects.filters.ChunkingInputStream;

public class ASCII85Decode
extends ChunkingInputStream {
    private boolean eof = false;

    public ASCII85Decode(InputStream input) {
        this.setInputStream(input);
        this.setBufferSize(4);
    }

    @Override
    protected int fillInternalBuffer() throws IOException {
        int count;
        long value;
        block13: {
            if (this.eof) {
                return -1;
            }
            value = 0L;
            count = 0;
            long c = 0L;
            while (true) {
                if ((c = (long)this.in.read()) < 0L) {
                    this.eof = true;
                    break block13;
                }
                if (c == 0L || c == 9L || c == 10L || c == 12L || c == 13L || c == 32L) continue;
                if (c == 126L) {
                    this.eof = true;
                    break block13;
                }
                if (c == 122L) {
                    this.buffer[0] = 0;
                    this.buffer[1] = 0;
                    this.buffer[2] = 0;
                    this.buffer[3] = 0;
                    count = 0;
                    return 4;
                }
                value = value * 85L + (c - 33L);
                if (++count == 5) break;
            }
            this.buffer[0] = (byte)(value >> 24 & 0xFFL);
            this.buffer[1] = (byte)(value >> 16 & 0xFFL);
            this.buffer[2] = (byte)(value >> 8 & 0xFFL);
            this.buffer[3] = (byte)(value & 0xFFL);
            value = 0L;
            count = 0;
            return 4;
        }
        if (count == 2) {
            value = value * 614125L + 0xFFFFFFL;
        } else if (count == 3) {
            value = value * 7225L + 65535L;
        } else if (count == 4) {
            value = value * 85L + 255L;
        }
        if (count >= 2) {
            this.buffer[0] = (byte)(value >> 24 & 0xFFL);
        }
        if (count >= 3) {
            this.buffer[1] = (byte)(value >> 16 & 0xFFL);
        }
        if (count >= 4) {
            this.buffer[2] = (byte)(value >> 8 & 0xFFL);
        }
        return count - 1;
    }
}

