/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.OptionalContentGroup;
import org.icepdf.core.pobjects.OptionalContents;
import org.icepdf.core.util.Library;

public class OptionalContentMembership
extends Dictionary
implements OptionalContents {
    public static final Name TYPE = new Name("OCMD");
    public static final Name OCGs_KEY = new Name("OCGs");
    public static final Name P_KEY = new Name("P");
    public static final Name VE_KEY = new Name("VE");
    public static final Name ALL_ON_KEY = new Name("AllOn");
    public static final Name ALL_OFF_KEY = new Name("AllOff");
    public static final Name ANY_ON_KEY = new Name("AnyOn");
    public static final Name ANY_OFF_KEY = new Name("AnyOff");
    private VisibilityPolicy policy;
    private List<OptionalContentGroup> ocgs = new ArrayList<OptionalContentGroup>();
    private List visibilityExpression;

    public OptionalContentMembership(Library library, HashMap entries) {
        super(library, entries);
    }

    @Override
    public void init() {
        if (this.inited) {
            return;
        }
        Object ocgObj = this.library.getObject(this.entries, OCGs_KEY);
        if (ocgObj instanceof OptionalContentGroup) {
            this.ocgs.add((OptionalContentGroup)ocgObj);
        } else if (ocgObj instanceof List) {
            List ocgList = (List)ocgObj;
            for (Object object : ocgList) {
                Object ocg = this.library.getObject(object);
                if (!(ocg instanceof OptionalContentGroup)) continue;
                this.ocgs.add((OptionalContentGroup)ocg);
            }
        }
        this.policy = VisibilityPolicy.getPolicy(this.library.getName(this.entries, P_KEY));
        this.inited = true;
    }

    @Override
    public boolean isOCG() {
        return true;
    }

    public VisibilityPolicy getPolicy() {
        return this.policy;
    }

    public List<OptionalContentGroup> getOcgs() {
        return this.ocgs;
    }

    @Override
    public boolean isVisible() {
        return this.policy.isVisible(this.ocgs);
    }

    public static enum VisibilityPolicy {
        ALL_ON{

            @Override
            boolean isVisible(List<OptionalContentGroup> ocgs) {
                for (OptionalContentGroup ocg : ocgs) {
                    if (ocg.isVisible()) continue;
                    return false;
                }
                return true;
            }
        }
        ,
        ANY_ON{

            @Override
            boolean isVisible(List<OptionalContentGroup> ocgs) {
                for (OptionalContentGroup ocg : ocgs) {
                    if (!ocg.isVisible()) continue;
                    return true;
                }
                return false;
            }
        }
        ,
        ANY_OFF{

            @Override
            boolean isVisible(List<OptionalContentGroup> ocgs) {
                for (OptionalContentGroup ocg : ocgs) {
                    if (ocg.isVisible()) continue;
                    return true;
                }
                return false;
            }
        }
        ,
        ALL_OFF{

            @Override
            boolean isVisible(List<OptionalContentGroup> ocgs) {
                for (OptionalContentGroup ocg : ocgs) {
                    if (!ocg.isVisible()) continue;
                    return false;
                }
                return true;
            }
        };


        public static VisibilityPolicy getPolicy(Name p) {
            if (ALL_ON_KEY.equals(p)) {
                return ALL_ON;
            }
            if (ALL_OFF_KEY.equals(p)) {
                return ALL_OFF;
            }
            if (ANY_ON_KEY.equals(p)) {
                return ANY_ON;
            }
            if (ANY_OFF_KEY.equals(p)) {
                return ANY_OFF;
            }
            if (ANY_OFF_KEY.equals(p)) {
                return ALL_OFF;
            }
            return ANY_ON;
        }

        abstract boolean isVisible(List<OptionalContentGroup> var1);
    }
}

