/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.SecurityCallback;
import org.icepdf.core.application.ProductInfo;
import org.icepdf.core.exceptions.PDFException;
import org.icepdf.core.exceptions.PDFSecurityException;
import org.icepdf.core.io.ConservativeSizingByteArrayOutputStream;
import org.icepdf.core.io.RandomAccessFileInputStream;
import org.icepdf.core.io.SeekableByteArrayInputStream;
import org.icepdf.core.io.SeekableInput;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.Catalog;
import org.icepdf.core.pobjects.CrossReference;
import org.icepdf.core.pobjects.PDimension;
import org.icepdf.core.pobjects.PInfo;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PTrailer;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.StateManager;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.core.pobjects.security.SecurityManager;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.LazyObjectLoader;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Parser;

public class Document {
    private static final Logger logger = Logger.getLogger(Document.class.toString());
    private static final String INCREMENTAL_UPDATER = "org.icepdf.core.util.IncrementalUpdater";
    public static boolean foundIncrementalUpdater;
    private Catalog catalog;
    private PTrailer pTrailer;
    private StateManager stateManager;
    private String origin;
    private String cachedFilePath;
    private SecurityCallback securityCallback;
    private static boolean isCachingEnabled;
    private Library library = null;
    private SeekableInput documentSeekableInput;

    public static String getLibraryVersion() {
        return ProductInfo.PRIMARY + "." + ProductInfo.SECONDARY + "." + ProductInfo.TERTIARY + " " + ProductInfo.RELEASE_TYPE;
    }

    private void setDocumentOrigin(String o) {
        this.origin = o;
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("MEMFREE: " + Runtime.getRuntime().freeMemory() + " of " + Runtime.getRuntime().totalMemory());
            logger.config("LOADING: " + o);
        }
    }

    private void setDocumentCachedFilePath(String o) {
        this.cachedFilePath = o;
    }

    private String getDocumentCachedFilePath() {
        return this.cachedFilePath;
    }

    public void setFile(String filepath) throws PDFException, PDFSecurityException, IOException {
        this.setDocumentOrigin(filepath);
        RandomAccessFileInputStream rafis = RandomAccessFileInputStream.build(new File(filepath));
        this.setInputStream(rafis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUrl(URL url) throws PDFException, PDFSecurityException, IOException {
        InputStream in = null;
        try {
            URLConnection urlConnection = url.openConnection();
            in = urlConnection.getInputStream();
            String pathOrURL = url.toString();
            this.setInputStream(in, pathOrURL);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void setInputStream(InputStream in, String pathOrURL) throws PDFException, PDFSecurityException, IOException {
        this.setDocumentOrigin(pathOrURL);
        if (!isCachingEnabled) {
            int length;
            ConservativeSizingByteArrayOutputStream byteArrayOutputStream = new ConservativeSizingByteArrayOutputStream(102400);
            byte[] buffer = new byte[4096];
            while ((length = in.read(buffer, 0, buffer.length)) > 0) {
                byteArrayOutputStream.write(buffer, 0, length);
            }
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            int size = byteArrayOutputStream.size();
            byteArrayOutputStream.trim();
            byte[] data = byteArrayOutputStream.relinquishByteArray();
            SeekableByteArrayInputStream byteArrayInputStream = new SeekableByteArrayInputStream(data, 0, size);
            this.setInputStream(byteArrayInputStream);
        } else {
            int length;
            File tempFile = File.createTempFile("ICEpdfTempFile" + this.getClass().hashCode(), ".tmp");
            tempFile.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(tempFile.getAbsolutePath(), true);
            byte[] buffer = new byte[4096];
            while ((length = in.read(buffer, 0, buffer.length)) > 0) {
                fileOutputStream.write(buffer, 0, length);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
            this.setDocumentCachedFilePath(tempFile.getAbsolutePath());
            RandomAccessFileInputStream rafis = RandomAccessFileInputStream.build(tempFile);
            this.setInputStream(rafis);
        }
    }

    public void setByteArray(byte[] data, int offset, int length, String pathOrURL) throws PDFException, PDFSecurityException, IOException {
        this.setDocumentOrigin(pathOrURL);
        if (!isCachingEnabled) {
            SeekableByteArrayInputStream byteArrayInputStream = new SeekableByteArrayInputStream(data, offset, length);
            this.setInputStream(byteArrayInputStream);
        } else {
            File tempFile = File.createTempFile("ICEpdfTempFile" + this.getClass().hashCode(), ".tmp");
            tempFile.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(tempFile.getAbsolutePath(), true);
            fileOutputStream.write(data, offset, length);
            fileOutputStream.flush();
            fileOutputStream.close();
            this.setDocumentCachedFilePath(tempFile.getAbsolutePath());
            RandomAccessFileInputStream rafis = RandomAccessFileInputStream.build(tempFile);
            this.setInputStream(rafis);
        }
    }

    public void setInputStream(SeekableInput in, String pathOrURL) throws PDFException, PDFSecurityException, IOException {
        this.setDocumentOrigin(pathOrURL);
        this.setInputStream(in);
    }

    private void setInputStream(SeekableInput in) throws PDFException, PDFSecurityException, IOException {
        try {
            boolean loaded;
            block14: {
                this.documentSeekableInput = in;
                this.library = new Library();
                loaded = false;
                try {
                    this.loadDocumentViaXRefs(in);
                    if (this.catalog != null) {
                        this.catalog.init();
                    }
                    loaded = true;
                }
                catch (PDFException e) {
                    throw e;
                }
                catch (PDFSecurityException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.WARNING)) break block14;
                    logger.warning("Cross reference deferred loading failed, will fall back to linear reading.");
                }
            }
            if (!loaded) {
                if (this.catalog != null) {
                    this.catalog = null;
                }
                if (this.library != null) {
                    this.library = null;
                }
                this.library = new Library();
                this.pTrailer = null;
                in.seekAbsolute(0L);
                this.loadDocumentViaLinearTraversal(in);
                if (this.catalog != null) {
                    this.catalog.init();
                }
            }
            this.stateManager = new StateManager(this.pTrailer);
            this.library.setStateManager(this.stateManager);
        }
        catch (PDFException e) {
            logger.log(Level.FINE, "Error loading PDF file during linear parse.", e);
            this.dispose();
            throw e;
        }
        catch (PDFSecurityException e) {
            this.dispose();
            throw e;
        }
        catch (IOException e) {
            this.dispose();
            throw e;
        }
        catch (Exception e) {
            this.dispose();
            logger.log(Level.SEVERE, "Error loading PDF Document.", e);
            throw new IOException(e.getMessage());
        }
    }

    private void loadDocumentViaXRefs(SeekableInput in) throws PDFException, PDFSecurityException, IOException {
        int offset = this.skipPastAnyPrefixJunk(in);
        long xrefPosition = this.getInitialCrossReferencePosition(in) + (long)offset;
        PTrailer documentTrailer = null;
        if (xrefPosition > 0L) {
            PTrailer trailer;
            in.seekAbsolute(xrefPosition);
            Parser parser = new Parser(in);
            Object obj = parser.getObject(this.library);
            if (obj instanceof PObject) {
                obj = ((PObject)obj).getObject();
            }
            if ((trailer = (PTrailer)obj) == null) {
                throw new RuntimeException("Could not find trailer");
            }
            if (trailer.getPrimaryCrossReference() == null) {
                throw new RuntimeException("Could not find cross reference");
            }
            trailer.setPosition(xrefPosition);
            documentTrailer = trailer;
        }
        if (documentTrailer == null) {
            throw new RuntimeException("Could not find document trailer");
        }
        if (offset > 0) {
            documentTrailer.getCrossReferenceTable().setOffset(offset);
        }
        LazyObjectLoader lol = new LazyObjectLoader(this.library, in, documentTrailer.getPrimaryCrossReference());
        this.library.setLazyObjectLoader(lol);
        this.pTrailer = documentTrailer;
        this.catalog = documentTrailer.getRootCatalog();
        this.library.setCatalog(this.catalog);
        if (this.catalog == null) {
            throw new NullPointerException("Loading via xref failed to find catalog");
        }
        boolean madeSecurityManager = this.makeSecurityManager(documentTrailer);
        if (madeSecurityManager) {
            this.attemptAuthorizeSecurityManager();
        }
    }

    private long getInitialCrossReferencePosition(SeekableInput in) throws IOException {
        in.seekEnd();
        long endOfFile = in.getAbsolutePosition();
        long afterStartxref = -1L;
        String startxref = "startxref";
        int startxrefIndexToMatch = startxref.length() - 1;
        for (long currentPosition = endOfFile - 1L; currentPosition >= 0L && endOfFile - currentPosition < 2048L; --currentPosition) {
            in.seekAbsolute(currentPosition);
            int curr = in.read();
            if (curr < 0) {
                throw new EOFException("Could not find startxref at end of file");
            }
            if (curr == startxref.charAt(startxrefIndexToMatch)) {
                if (startxrefIndexToMatch == 0) {
                    afterStartxref = currentPosition + (long)startxref.length();
                    break;
                }
                --startxrefIndexToMatch;
                continue;
            }
            startxrefIndexToMatch = startxref.length() - 1;
        }
        if (afterStartxref < 0L) {
            throw new EOFException("Could not find startxref near end of file");
        }
        in.seekAbsolute(afterStartxref);
        Parser parser = new Parser(in);
        Number xrefPositionObj = (Number)parser.getToken();
        if (xrefPositionObj == null) {
            throw new RuntimeException("Could not find ending cross reference position");
        }
        return xrefPositionObj.longValue();
    }

    private void loadDocumentViaLinearTraversal(SeekableInput seekableInput) throws PDFException, PDFSecurityException, IOException {
        boolean madeSecurityManager;
        Object pdfObject;
        InputStream in = seekableInput.getInputStream();
        int objectsOffset = this.skipPastAnyPrefixJunk(in);
        this.library.setLinearTraversal();
        Parser parser = new Parser(in);
        PTrailer documentTrailer = null;
        ArrayList<PObject> documentObjects = new ArrayList<PObject>();
        while ((pdfObject = parser.getObject(this.library)) != null) {
            if (pdfObject instanceof PObject) {
                PObject tmp = (PObject)pdfObject;
                tmp.setLinearTraversalOffset(objectsOffset + parser.getLinearTraversalOffset());
                documentObjects.add(tmp);
                Object obj = tmp.getObject();
                if (obj != null) {
                    pdfObject = obj;
                }
            }
            if (pdfObject instanceof Catalog) {
                this.catalog = (Catalog)pdfObject;
            }
            if (!(pdfObject instanceof PTrailer)) continue;
            if (documentTrailer == null) {
                documentTrailer = (PTrailer)pdfObject;
                continue;
            }
            PTrailer nextTrailer = (PTrailer)pdfObject;
            if (nextTrailer.getPrev() <= 0L) continue;
            documentTrailer.addNextTrailer(nextTrailer);
            documentTrailer = nextTrailer;
        }
        CrossReference refs = documentTrailer.getPrimaryCrossReference();
        for (PObject pObject : documentObjects) {
            CrossReference.Entry entry = refs.getEntryForObject(pObject.getReference().getObjectNumber());
            if (entry != null && entry instanceof CrossReference.UsedEntry) {
                ((CrossReference.UsedEntry)entry).setFilePositionOfObject(pObject.getLinearTraversalOffset());
                continue;
            }
            refs.addUsedEntry(pObject.getReference().getObjectNumber(), pObject.getLinearTraversalOffset(), pObject.getReference().getGenerationNumber());
        }
        if (logger.isLoggable(Level.FINER)) {
            for (PObject pobjects : documentObjects) {
                logger.finer(pobjects.getClass().getName() + " " + pobjects.getLinearTraversalOffset() + " " + pobjects);
            }
        }
        if (documentTrailer != null) {
            LazyObjectLoader lol = new LazyObjectLoader(this.library, seekableInput, documentTrailer.getPrimaryCrossReference());
            this.library.setLazyObjectLoader(lol);
        }
        this.pTrailer = documentTrailer;
        this.library.setCatalog(this.catalog);
        if (documentTrailer != null && (madeSecurityManager = this.makeSecurityManager(documentTrailer))) {
            this.attemptAuthorizeSecurityManager();
        }
    }

    private int skipPastAnyPrefixJunk(InputStream in) {
        if (!in.markSupported()) {
            return 0;
        }
        try {
            int scanLength = 2048;
            String scanFor = "%PDF-";
            int scanForLength = "%PDF-".length();
            int scanForIndex = 0;
            boolean scanForWhiteSpace = false;
            in.mark(2048);
            for (int i = 0; i < 2048; ++i) {
                int data = in.read();
                if (data < 0) {
                    in.reset();
                    return 0;
                }
                if (scanForWhiteSpace) {
                    ++scanForIndex;
                    if (!Parser.isWhitespace((char)data)) continue;
                    return scanForIndex;
                }
                if (data == "%PDF-".charAt(scanForIndex)) {
                    if (++scanForIndex != scanForLength) continue;
                    scanForWhiteSpace = true;
                    continue;
                }
                scanForIndex = 0;
            }
            in.reset();
        }
        catch (IOException e) {
            try {
                in.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0;
    }

    private int skipPastAnyPrefixJunk(SeekableInput in) {
        if (!in.markSupported()) {
            return 0;
        }
        try {
            int scanLength = 2048;
            String scanFor = "%PDF-1.";
            int scanForIndex = 0;
            in.mark(2048);
            for (int i = 0; i < 2048; ++i) {
                int data = in.read();
                if (data < 0) {
                    in.reset();
                    return 0;
                }
                if (data == "%PDF-1.".charAt(scanForIndex)) {
                    return i;
                }
                scanForIndex = 0;
            }
            in.reset();
        }
        catch (IOException e) {
            try {
                in.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0;
    }

    private boolean makeSecurityManager(PTrailer documentTrailer) throws PDFSecurityException {
        boolean madeSecurityManager = false;
        HashMap encryptDictionary = documentTrailer.getEncrypt();
        List fileID = documentTrailer.getID();
        if (encryptDictionary != null && fileID != null) {
            this.library.securityManager = new SecurityManager(this.library, encryptDictionary, fileID);
            madeSecurityManager = true;
        }
        return madeSecurityManager;
    }

    private void attemptAuthorizeSecurityManager() throws PDFSecurityException {
        block5: {
            if (!this.library.securityManager.isAuthorized("")) {
                int count = 1;
                do {
                    String password;
                    if (this.securityCallback != null) {
                        password = this.securityCallback.requestPassword(this);
                        if (password == null) {
                            throw new PDFSecurityException("Encryption error");
                        }
                    } else {
                        throw new PDFSecurityException("Encryption error");
                    }
                    if (this.library.securityManager.isAuthorized(password)) break block5;
                } while (++count <= 3);
                throw new PDFSecurityException("Encryption error");
            }
        }
        this.library.setEncrypted(true);
    }

    public PDimension getPageDimension(int pageNumber, float userRotation) {
        Page page = this.catalog.getPageTree().getPage(pageNumber);
        page.init();
        return page.getSize(userRotation);
    }

    public PDimension getPageDimension(int pageNumber, float userRotation, float userZoom) {
        Page page = this.catalog.getPageTree().getPage(pageNumber);
        page.init();
        if (page != null) {
            return page.getSize(userRotation, userZoom);
        }
        return new PDimension(0, 0);
    }

    public String getDocumentOrigin() {
        return this.origin;
    }

    public String getDocumentLocation() {
        if (this.cachedFilePath != null) {
            return this.cachedFilePath;
        }
        return this.origin;
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public int getNumberOfPages() {
        try {
            return this.catalog.getPageTree().getNumberOfPages();
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error getting number of pages.", e);
            return 0;
        }
    }

    public void paintPage(int pageNumber, Graphics g, int renderHintType, int pageBoundary, float userRotation, float userZoom) {
        Page page = this.catalog.getPageTree().getPage(pageNumber);
        page.init();
        PDimension sz = page.getSize(userRotation, userZoom);
        int pageWidth = (int)sz.getWidth();
        int pageHeight = (int)sz.getHeight();
        Graphics gg = g.create(0, 0, pageWidth, pageHeight);
        page.paint(gg, renderHintType, pageBoundary, userRotation, userZoom);
        gg.dispose();
    }

    public void dispose() {
        File file;
        boolean success;
        String fileToDelete;
        if (this.documentSeekableInput != null) {
            try {
                this.documentSeekableInput.close();
            }
            catch (IOException e) {
                logger.log(Level.FINE, "Error closing document input stream.", e);
            }
            this.documentSeekableInput = null;
        }
        if ((fileToDelete = this.getDocumentCachedFilePath()) != null && !(success = (file = new File(fileToDelete)).delete()) && logger.isLoggable(Level.WARNING)) {
            logger.warning("Error deleting URL cached to file " + fileToDelete);
        }
    }

    public long writeToOutputStream(OutputStream out) throws IOException {
        long documentLength = this.documentSeekableInput.getLength();
        SeekableInputConstrainedWrapper wrapper = new SeekableInputConstrainedWrapper(this.documentSeekableInput, 0L, documentLength);
        try {
            int length;
            byte[] buffer = new byte[4096];
            while ((length = wrapper.read(buffer, 0, buffer.length)) > 0) {
                out.write(buffer, 0, length);
            }
        }
        catch (Throwable e) {
            logger.log(Level.FINE, "Error writing PDF output stream.", e);
            throw new IOException(e.getMessage());
        }
        finally {
            try {
                wrapper.close();
            }
            catch (IOException e) {}
        }
        return documentLength;
    }

    public long saveToOutputStream(OutputStream out) throws IOException {
        long documentLength = this.writeToOutputStream(out);
        if (foundIncrementalUpdater) {
            try {
                Class<?> incrementalUpdaterClass = Class.forName(INCREMENTAL_UPDATER);
                Object[] argValues = new Object[]{this, out, documentLength};
                Method method = incrementalUpdaterClass.getDeclaredMethod("appendIncrementalUpdate", Document.class, OutputStream.class, Long.TYPE);
                long appendedLength = (Long)method.invoke(null, argValues);
                return documentLength + appendedLength;
            }
            catch (Throwable e) {
                logger.log(Level.FINE, "Could not call incremental updater.", e);
            }
        }
        return documentLength;
    }

    public Image getPageImage(int pageNumber, int renderHintType, int pageBoundary, float userRotation, float userZoom) {
        Page page = this.catalog.getPageTree().getPage(pageNumber);
        page.init();
        PDimension sz = page.getSize(pageBoundary, userRotation, userZoom);
        int pageWidth = (int)sz.getWidth();
        int pageHeight = (int)sz.getHeight();
        BufferedImage image = new BufferedImage(pageWidth, pageHeight, 1);
        Graphics2D g = image.createGraphics();
        page.paint(g, renderHintType, pageBoundary, userRotation, userZoom);
        g.dispose();
        return image;
    }

    public PageText getPageText(int pageNumber) throws InterruptedException {
        PageTree pageTree = this.catalog.getPageTree();
        if (pageNumber >= 0 && pageNumber < pageTree.getNumberOfPages()) {
            Page pg = pageTree.getPage(pageNumber);
            return pg.getText();
        }
        return null;
    }

    public PageText getPageViewText(int pageNumber) {
        PageTree pageTree = this.catalog.getPageTree();
        if (pageNumber >= 0 && pageNumber < pageTree.getNumberOfPages()) {
            Page pg = pageTree.getPage(pageNumber);
            return pg.getViewText();
        }
        return null;
    }

    public SecurityManager getSecurityManager() {
        return this.library.securityManager;
    }

    public void setSecurityCallback(SecurityCallback securityCallback) {
        this.securityCallback = securityCallback;
    }

    public PInfo getInfo() {
        if (this.pTrailer == null) {
            return null;
        }
        return this.pTrailer.getInfo();
    }

    public List<Image> getPageImages(int pageNumber) {
        Page pg = this.catalog.getPageTree().getPage(pageNumber);
        pg.init();
        return pg.getImages();
    }

    public PageTree getPageTree() {
        if (this.catalog != null) {
            return this.catalog.getPageTree();
        }
        return null;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public static void setCachingEnabled(boolean cachingEnabled) {
        isCachingEnabled = cachingEnabled;
    }

    static {
        try {
            Class.forName(INCREMENTAL_UPDATER);
            foundIncrementalUpdater = true;
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, "PDF write support was not found on the class path");
        }
        isCachingEnabled = Defs.sysPropertyBoolean("org.icepdf.core.streamcache.enabled", true);
    }
}

