/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableInput;

public class RandomAccessFileInputStream
extends InputStream
implements SeekableInput {
    private static final Logger logger = Logger.getLogger(RandomAccessFileInputStream.class.toString());
    private long m_lMarkPosition = 0L;
    private RandomAccessFile m_RandomAccessFile;
    private final ReentrantLock lock = new ReentrantLock();

    public static RandomAccessFileInputStream build(File file) throws FileNotFoundException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        return new RandomAccessFileInputStream(raf);
    }

    protected RandomAccessFileInputStream(RandomAccessFile raf) {
        this.m_RandomAccessFile = raf;
    }

    @Override
    public int read() throws IOException {
        return this.m_RandomAccessFile.read();
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.m_RandomAccessFile.read(buffer);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this.m_RandomAccessFile.read(buffer, offset, length);
    }

    @Override
    public void close() throws IOException {
        this.m_RandomAccessFile.close();
    }

    @Override
    public int available() {
        try {
            return (int)this.m_RandomAccessFile.getFilePointer();
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.WARNING, "Error calling available", e);
            }
            return 0;
        }
    }

    @Override
    public void mark(int readLimit) {
        try {
            this.m_lMarkPosition = this.m_RandomAccessFile.getFilePointer();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void reset() throws IOException {
        this.m_RandomAccessFile.seek(this.m_lMarkPosition);
    }

    @Override
    public long skip(long n) throws IOException {
        int nn = (int)(n & 0xFFFFFFFFFFFFFFFFL);
        return this.m_RandomAccessFile.skipBytes(nn);
    }

    @Override
    public void seekAbsolute(long absolutePosition) throws IOException {
        this.m_RandomAccessFile.seek(absolutePosition);
    }

    @Override
    public void seekRelative(long relativeOffset) throws IOException {
        long pos = this.m_RandomAccessFile.getFilePointer();
        if ((pos += relativeOffset) < 0L) {
            pos = 0L;
        }
        this.m_RandomAccessFile.seek(pos);
    }

    @Override
    public void seekEnd() throws IOException {
        long end = this.m_RandomAccessFile.length();
        this.seekAbsolute(end);
    }

    @Override
    public long getAbsolutePosition() throws IOException {
        return this.m_RandomAccessFile.getFilePointer();
    }

    @Override
    public long getLength() throws IOException {
        return this.m_RandomAccessFile.length();
    }

    @Override
    public InputStream getInputStream() {
        return this;
    }

    @Override
    public void beginThreadAccess() {
        this.lock.lock();
    }

    @Override
    public void endThreadAccess() {
        this.lock.unlock();
    }
}

