/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.io;

import java.io.IOException;
import java.io.OutputStream;

public class ConservativeSizingByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;

    public ConservativeSizingByteArrayOutputStream(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Negative initial capacity: " + capacity);
        }
        this.buf = this.allocateByteArray(capacity);
        this.count = 0;
    }

    public ConservativeSizingByteArrayOutputStream(byte[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("Initial buffer is null");
        }
        if (buffer.length == 0) {
            throw new IllegalArgumentException("Initial buffer has zero length");
        }
        this.buf = buffer;
        this.count = 0;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        int newCount = this.count + 1;
        if (newCount > this.buf.length) {
            this.resizeArrayToFit(newCount);
        }
        this.buf[this.count] = (byte)b;
        this.count = newCount;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (off < 0 || off >= b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newCount = this.count + len;
        if (newCount > this.buf.length) {
            this.resizeArrayToFit(newCount);
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newCount;
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public synchronized byte[] toByteArray() {
        byte[] newBuf = this.allocateByteArray(this.count);
        System.arraycopy(this.buf, 0, newBuf, 0, this.count);
        return newBuf;
    }

    public int size() {
        return this.count;
    }

    public synchronized byte[] relinquishByteArray() {
        byte[] returnBuf = this.buf;
        this.buf = new byte[64];
        this.count = 0;
        return returnBuf;
    }

    public boolean trim() {
        if (this.count == 0 && (this.buf == null || this.buf.length == 0)) {
            return true;
        }
        if (this.count == this.buf.length) {
            return true;
        }
        byte[] newBuf = this.allocateByteArray(this.count);
        if (newBuf == null) {
            return false;
        }
        System.arraycopy(this.buf, 0, newBuf, 0, this.count);
        this.buf = null;
        this.buf = newBuf;
        return true;
    }

    protected void resizeArrayToFit(int newCount) {
        int steppedSize = this.buf.length;
        if (steppedSize == 0) {
            steppedSize = 64;
        } else if (steppedSize <= 1024) {
            steppedSize *= 4;
        } else if (steppedSize <= 4024) {
            steppedSize *= 2;
        } else if (steppedSize <= 0x200000) {
            steppedSize *= 2;
            steppedSize &= 0xFFFFF000;
        } else if (steppedSize <= 0x400000) {
            steppedSize = steppedSize * 3 / 2;
            steppedSize &= 0xFFFFF000;
        } else if (steppedSize <= 0xF00000) {
            steppedSize = steppedSize * 5 / 4;
            steppedSize &= 0xFFFFF000;
        } else {
            steppedSize += 0x300000;
            steppedSize &= 0xFFFFF000;
        }
        int newBufSize = Math.max(steppedSize, newCount);
        byte[] newBuf = this.allocateByteArray(newBufSize);
        System.arraycopy(this.buf, 0, newBuf, 0, this.count);
        this.buf = newBuf;
    }

    protected byte[] allocateByteArray(int size) {
        return new byte[size];
    }
}

