/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.printpdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import se.sjobeck.geometra.datastructures.drawings.DotDrawing;
import se.sjobeck.geometra.datastructures.drawings.DotDrawingContainer;
import se.sjobeck.geometra.datastructures.drawings.GeometraDrawingImpl;
import se.sjobeck.geometra.datastructures.drawings.HoleDrawing;
import se.sjobeck.geometra.datastructures.drawings.LineDrawing;
import se.sjobeck.geometra.datastructures.drawings.SmartDrawing;
import se.sjobeck.geometra.datastructures.drawings.SquareDrawing;
import se.sjobeck.geometra.datastructures.drawings.TextDrawing;
import se.sjobeck.geometra.gui.main.Geometra;
import se.sjobeck.geometra.printpdf.AbstractPDFWriter;
import se.sjobeck.geometra.printpdf.PrintPDF;

public class PrintPDF2
extends AbstractPDFWriter {
    private int x_offset = 0;
    private int y_offset = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printPDF_pages_only(List<GeometraDrawingImpl> geolist, String inpdfFile, String outpdfFile, AbstractPDFWriter.ROTATION rot) {
        Document document = null;
        PdfWriter w = null;
        PdfReader r = null;
        try {
            this.rot = rot;
            r = new PdfReader(inpdfFile);
            document = new Document();
            w = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(outpdfFile));
            document.open();
            PdfContentByte directContent = w.getDirectContent();
            AbstractPDFWriter.GeometraDrawingImplSorter gdis = new AbstractPDFWriter.GeometraDrawingImplSorter();
            for (GeometraDrawingImpl gdi : geolist) {
                gdis.insert(gdi);
            }
            while (gdis != null) {
                Vector<GeometraDrawingImpl> v = gdis.getDrawings();
                int sidNummer = gdis.getSidnummer();
                document.setPageSize(r.getPageSize(sidNummer + 1));
                document.newPage();
                PdfImportedPage importedPage = w.getImportedPage(r, sidNummer + 1);
                this.width = importedPage.getWidth();
                this.height = importedPage.getHeight();
                directContent.addTemplate((PdfTemplate)importedPage, 0.0f, 0.0f);
                for (GeometraDrawingImpl gdi : v) {
                    this.printGeometraDrawingImpl(gdi, directContent, sidNummer, null);
                }
                gdis = gdis.getNext();
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(PrintPDF.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(PrintPDF.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (DocumentException ex) {
            Logger.getLogger(PrintPDF.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (document != null) {
                document.close();
            }
            if (w != null) {
                w.close();
            }
            if (r != null) {
                r.close();
            }
        }
    }

    private void printGeometraDrawingImpl(GeometraDrawingImpl gdi, PdfContentByte pcb, int sidnr, Color overloadColor) {
        block4: {
            block9: {
                float linewidth;
                BlueprintPage page1;
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                page1 = gdi.getParent();
                                Blueprint blueprint = gdi.getParent().getParent();
                                BlueprintPage page2 = blueprint.getPage(sidnr);
                                linewidth = 1.0f;
                                if (!page1.equals(page2)) break block4;
                                if (!(gdi instanceof TextDrawing)) break block5;
                                Color color = overloadColor == null ? gdi.getColor() : overloadColor;
                                this.printText4(pcb, color, (TextDrawing)gdi);
                                break block4;
                            }
                            if (!(gdi instanceof SquareDrawing)) break block6;
                            List<Point2D> points = gdi.getPoints();
                            Color color = overloadColor == null ? gdi.getColor() : overloadColor;
                            boolean fill = gdi.isFilled();
                            boolean text2d = gdi.isTwoDimensionsVisible();
                            boolean text3d = gdi.isThreeDimensionsVisible();
                            this.paintPoints(pcb, color, Color.DARK_GRAY, linewidth, points, fill, text2d, text3d, page1, gdi.getHeight(), gdi.getArea(), true, true);
                            List<HoleDrawing> children = ((SquareDrawing)gdi).getChildren();
                            for (HoleDrawing hd : children) {
                                points = hd.getPoints();
                                color = hd.getColor();
                                fill = hd.isFilled();
                                text2d = false;
                                text3d = false;
                                this.paintPoints(pcb, color, Color.DARK_GRAY, linewidth, points, fill, text2d, text3d, page1, hd.getHeight(), hd.getArea(), false, false);
                            }
                            break block4;
                        }
                        if (!(gdi instanceof DotDrawingContainer)) break block7;
                        DotDrawingContainer ddc = (DotDrawingContainer)gdi;
                        List<DotDrawing> children = ddc.getChildren();
                        for (DotDrawing dd : children) {
                            Color color = overloadColor == null ? dd.getColor() : overloadColor;
                            List<Point2D> points = dd.getPoints();
                            boolean fill = true;
                            boolean text2d = false;
                            boolean text3d = false;
                            this.paintPoints(pcb, color, Color.DARK_GRAY, linewidth, points, fill, text2d, text3d, page1, gdi.getHeight(), gdi.getArea(), false, false);
                        }
                        break block4;
                    }
                    if (!(gdi instanceof LineDrawing)) break block8;
                    Color color = overloadColor == null ? gdi.getColor() : overloadColor;
                    List<Point2D> points = gdi.getPoints();
                    boolean fill = false;
                    boolean text2d = gdi.isTwoDimensionsVisible();
                    boolean text3d = gdi.isThreeDimensionsVisible();
                    linewidth = ((LineDrawing)gdi).getLineWidth();
                    this.paintPoints(pcb, color, Color.DARK_GRAY, linewidth, points, fill, text2d, text3d, page1, gdi.getHeight(), gdi.getArea(), false, false);
                    break block4;
                }
                if (!(gdi instanceof DotDrawing)) break block9;
                Color color = overloadColor == null ? gdi.getColor() : overloadColor;
                List<Point2D> points = gdi.getPoints();
                boolean fill = true;
                boolean text2d = false;
                boolean text3d = false;
                this.paintPoints(pcb, color, Color.DARK_GRAY, linewidth, points, fill, text2d, text3d, page1, gdi.getHeight(), gdi.getArea(), false, false);
                break block4;
            }
            if (!(gdi instanceof SmartDrawing)) break block4;
            System.out.println("smartdrawing");
            SmartDrawing sd = (SmartDrawing)gdi;
            if (overloadColor == null) {
                overloadColor = sd.getColor();
            }
            for (int i = 0; i < sd.getChildCount(); ++i) {
                GeometraDrawingImpl child = (GeometraDrawingImpl)sd.getChild(i);
                this.printGeometraDrawingImpl(child, pcb, sidnr, overloadColor);
            }
        }
    }

    private void paintPoints(PdfContentByte pcb, Color colorFill, Color colorBorder, float linewidth, List<Point2D> points, boolean fill, boolean text2d, boolean text3d, BlueprintPage page1, double height_, double area, boolean area_or_volume, boolean close_path) {
        LinkedList<Point2D> lp2d = new LinkedList<Point2D>();
        for (Point2D p : points) {
            Point2D p1 = this.rotateMe(p);
            p1.setLocation(p1.getX() + (double)this.x_offset, p1.getY() + (double)this.y_offset);
            lp2d.add(p1);
        }
        PdfGState pdfgstate = new PdfGState();
        pdfgstate.setStrokeOpacity(this.line_opacity);
        pdfgstate.setFillOpacity(this.area_opacity);
        pcb.setGState(pdfgstate);
        float[] cf = new float[3];
        float[] cb = new float[3];
        colorFill.getRGBColorComponents(cf);
        colorBorder.getRGBColorComponents(cb);
        pcb.setRGBColorFillF(cf[0], cf[1], cf[2]);
        float[] temp_col = cf;
        if (!fill) {
            pcb.setRGBColorStrokeF(cf[0], cf[1], cf[2]);
        } else {
            pcb.setRGBColorStrokeF(cb[0], cb[1], cb[2]);
        }
        pcb.setLineWidth(linewidth);
        pcb.moveTo((float)((Point2D)lp2d.get(0)).getX(), (float)((Point2D)lp2d.get(0)).getY());
        for (int i = 1; i < lp2d.size(); ++i) {
            pcb.lineTo((float)((Point2D)lp2d.get(i)).getX(), (float)((Point2D)lp2d.get(i)).getY());
        }
        if (fill) {
            pcb.closePathFillStroke();
        } else if (close_path) {
            pcb.closePathStroke();
        } else {
            pcb.stroke();
        }
        double x_centre_of_gravity = 0.0;
        double y_centre_of_gravity = 0.0;
        int i = 0;
        if (!area_or_volume) {
            i = 1;
        }
        for (int j = 0; j < lp2d.size(); ++j) {
            x_centre_of_gravity += ((Point2D)lp2d.get(j)).getX();
            y_centre_of_gravity += ((Point2D)lp2d.get(j)).getY();
        }
        x_centre_of_gravity /= (double)lp2d.size();
        y_centre_of_gravity /= (double)lp2d.size();
        if (lp2d.size() > 1) {
            if (PrintPDF2.clockwise(((Point2D)lp2d.get(0)).getX() - x_centre_of_gravity, ((Point2D)lp2d.get(0)).getY() - y_centre_of_gravity, ((Point2D)lp2d.get(1)).getX() - x_centre_of_gravity, ((Point2D)lp2d.get(1)).getY() - y_centre_of_gravity) < 0.0) {
                while (i < lp2d.size()) {
                    this.innerstuff(i, lp2d, page1, pcb, text2d, text3d, x_centre_of_gravity, y_centre_of_gravity, temp_col, height_);
                    ++i;
                }
            } else {
                int end = 0;
                if (i == 1) {
                    end = 1;
                }
                for (i = lp2d.size() - 1; i >= end; --i) {
                    this.innerstuff2(i, lp2d, page1, pcb, text2d, text3d, x_centre_of_gravity, y_centre_of_gravity, temp_col, height_);
                }
            }
        }
        if (area_or_volume) {
            String area_string = Geometra.standardFormat.format(area);
            String volume_string = "(" + Geometra.standardFormat.format(area * height_) + ")";
            Font font = FontFactory.getFont((String)"Times");
            pcb.setFontAndSize(font.getBaseFont(), (float)this.textSize);
            if (text2d && text3d) {
                this.print_text(pcb, (float)x_centre_of_gravity - (float)this.textSize, (float)y_centre_of_gravity, area_string + volume_string, pdfgstate, temp_col);
            } else if (text2d) {
                this.print_text(pcb, (float)x_centre_of_gravity - (float)this.textSize, (float)y_centre_of_gravity, area_string, pdfgstate, temp_col);
            } else if (text3d) {
                this.print_text(pcb, (float)x_centre_of_gravity - (float)this.textSize, (float)y_centre_of_gravity, volume_string, pdfgstate, temp_col);
            }
        }
    }

    private void innerstuff(int i, List<Point2D> lp2d, BlueprintPage page1, PdfContentByte pcb, boolean text2d, boolean text3d, double x_centre_of_gravity, double y_centre_of_gravity, float[] temp_col, double height) {
        int f\u00f6rsta = i - 1 >= 0 ? i - 1 : lp2d.size() - 1;
        int andra = i;
        float x = (float)((lp2d.get(f\u00f6rsta).getX() + lp2d.get(andra).getX()) / 2.0);
        float y = (float)((lp2d.get(f\u00f6rsta).getY() + lp2d.get(andra).getY()) / 2.0);
        double dist = page1.scaleToReal(lp2d.get(andra).distance(lp2d.get(f\u00f6rsta)));
        double wall = dist * height;
        String dist_text = Geometra.standardFormat.format(dist);
        String wall_text = "(" + Geometra.standardFormat.format(wall) + ")";
        Font font = FontFactory.getFont((String)"Times");
        pcb.setFontAndSize(font.getBaseFont(), (float)this.textSize);
        if (text2d && text3d) {
            this.print_text3(pcb, x, y, lp2d.get(f\u00f6rsta), lp2d.get(andra), x_centre_of_gravity, y_centre_of_gravity, dist_text + wall_text, temp_col);
        } else if (text2d) {
            this.print_text3(pcb, x, y, lp2d.get(f\u00f6rsta), lp2d.get(andra), x_centre_of_gravity, y_centre_of_gravity, dist_text, temp_col);
        } else if (text3d) {
            this.print_text3(pcb, x, y, lp2d.get(f\u00f6rsta), lp2d.get(andra), x_centre_of_gravity, y_centre_of_gravity, wall_text, temp_col);
        }
    }

    private void innerstuff2(int i, List<Point2D> lp2d, BlueprintPage page1, PdfContentByte pcb, boolean text2d, boolean text3d, double x_centre_of_gravity, double y_centre_of_gravity, float[] temp_col, double height) {
        int andra;
        int f\u00f6rsta = i - 1 >= 0 ? i - 1 : lp2d.size() - 1;
        int temp = andra = i;
        andra = f\u00f6rsta;
        f\u00f6rsta = temp;
        float x = (float)((lp2d.get(f\u00f6rsta).getX() + lp2d.get(andra).getX()) / 2.0);
        float y = (float)((lp2d.get(f\u00f6rsta).getY() + lp2d.get(andra).getY()) / 2.0);
        double dist = page1.scaleToReal(lp2d.get(andra).distance(lp2d.get(f\u00f6rsta)));
        double wall = dist * height;
        String dist_text = Geometra.standardFormat.format(dist);
        String wall_text = "(" + Geometra.standardFormat.format(wall) + ")";
        Font font = FontFactory.getFont((String)"Times");
        pcb.setFontAndSize(font.getBaseFont(), (float)this.textSize);
        if (text2d && text3d) {
            this.print_text3(pcb, x, y, lp2d.get(f\u00f6rsta), lp2d.get(andra), x_centre_of_gravity, y_centre_of_gravity, dist_text + wall_text, temp_col);
        } else if (text2d) {
            this.print_text3(pcb, x, y, lp2d.get(f\u00f6rsta), lp2d.get(andra), x_centre_of_gravity, y_centre_of_gravity, dist_text, temp_col);
        } else if (text3d) {
            this.print_text3(pcb, x, y, lp2d.get(f\u00f6rsta), lp2d.get(andra), x_centre_of_gravity, y_centre_of_gravity, wall_text, temp_col);
        }
    }

    private void print_text(PdfContentByte pcb, float x, float y, String string, PdfGState pdfgstate, float[] temp_col) {
        if (!this.blackTextOnly) {
            pcb.setRGBColorFillF(temp_col[0], temp_col[1], temp_col[2]);
        } else {
            pcb.setRGBColorFillF(0.0f, 0.0f, 0.0f);
        }
        pcb.beginText();
        pcb.moveText(x, y);
        PdfGState pg = new PdfGState();
        pg.setFillOpacity(this.text_opacity);
        pcb.setGState(pg);
        pcb.showText(string);
        pcb.endText();
        pcb.setRGBColorFillF(temp_col[0], temp_col[1], temp_col[2]);
    }

    private void print_text3(PdfContentByte pcb, float x, float y, Point2D endpoint0, Point2D endpoint1, double x_centre_of_gravity, double y_centre_of_gravity, String text, float[] temp_col) {
        double x1x0 = endpoint1.getX() - endpoint0.getX();
        double y1y0 = endpoint1.getY() - endpoint0.getY();
        float cosD = (float)(x1x0 / Math.sqrt(x1x0 * x1x0 + y1y0 * y1y0));
        float sinD = (float)(y1y0 / Math.sqrt(x1x0 * x1x0 + y1y0 * y1y0));
        if (!this.blackTextOnly) {
            pcb.setRGBColorFillF(temp_col[0], temp_col[1], temp_col[2]);
        } else {
            pcb.setRGBColorFillF(0.0f, 0.0f, 0.0f);
        }
        pcb.beginText();
        x = (float)((double)this.textSize / Math.sqrt(x1x0 * x1x0 + y1y0 * y1y0) * (endpoint0.getX() - endpoint1.getX()) + (double)x);
        y = (float)((double)this.textSize / Math.sqrt(x1x0 * x1x0 + y1y0 * y1y0) * (endpoint0.getY() - endpoint1.getY()) + (double)y);
        pcb.setTextMatrix(cosD, sinD, -sinD, cosD, x, y);
        PdfGState pg = new PdfGState();
        pg.setFillOpacity(this.text_opacity);
        pcb.setGState(pg);
        pcb.showText(text);
        pcb.endText();
        pcb.setRGBColorFillF(temp_col[0], temp_col[1], temp_col[2]);
    }

    private static double clockwise(double x1, double y1, double x2, double y2) {
        return x2 * y1 - x1 * y2;
    }

    private void printText4(PdfContentByte pcb, Color color, TextDrawing textDrawing) {
        float[] tempCol = new float[3];
        tempCol = color.getRGBColorComponents(tempCol);
        pcb.setRGBColorFillF(tempCol[0], tempCol[1], tempCol[2]);
        Font font = FontFactory.getFont((String)"Times");
        pcb.setFontAndSize(font.getBaseFont(), (float)textDrawing.getTextSize());
        pcb.beginText();
        Point2D p1 = this.rotateMe(textDrawing.getPoints().get(0));
        this.setTextRotation(pcb, p1, textDrawing);
        PdfGState pg = new PdfGState();
        pg.setFillOpacity(this.text_opacity);
        pcb.setGState(pg);
        pcb.showText(textDrawing.getDescription());
        pcb.endText();
    }

    private void setTextRotation(PdfContentByte pcb, Point2D p1, TextDrawing td) {
        System.out.println((Object)this.rot);
        block0 : switch (this.rot) {
            case LowerLeft: {
                switch (td.getRotation()) {
                    case 0: {
                        pcb.setTextMatrix(1.0f, 0.0f, 0.0f, 1.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 90: {
                        pcb.setTextMatrix(0.0f, -1.0f, 1.0f, 0.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 180: {
                        pcb.setTextMatrix(-1.0f, 0.0f, 0.0f, -1.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 270: {
                        pcb.setTextMatrix(0.0f, 1.0f, -1.0f, 0.0f, (float)p1.getX(), (float)p1.getY());
                    }
                }
                break;
            }
            case LowerRight: {
                switch (td.getRotation()) {
                    case 0: {
                        pcb.setTextMatrix(-1.0f, 0.0f, 0.0f, -1.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 90: {
                        pcb.setTextMatrix(0.0f, -1.0f, 1.0f, 0.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 180: {
                        pcb.setTextMatrix(1.0f, 0.0f, 0.0f, 1.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 270: {
                        pcb.setTextMatrix(0.0f, 1.0f, -1.0f, 0.0f, (float)p1.getX(), (float)p1.getY());
                    }
                }
                break;
            }
            case UpperLeft: {
                switch (td.getRotation()) {
                    case 0: {
                        pcb.setTextMatrix(1.0f, 0.0f, 0.0f, 1.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 90: {
                        pcb.setTextMatrix(0.0f, 1.0f, -1.0f, 0.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 180: {
                        pcb.setTextMatrix(-1.0f, 0.0f, 0.0f, -1.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 270: {
                        pcb.setTextMatrix(0.0f, -1.0f, 1.0f, 0.0f, (float)p1.getX(), (float)p1.getY());
                    }
                }
                break;
            }
            case UpperRight: {
                switch (td.getRotation()) {
                    case 0: {
                        pcb.setTextMatrix(-1.0f, 0.0f, 0.0f, -1.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 90: {
                        pcb.setTextMatrix(0.0f, 1.0f, -1.0f, 0.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 180: {
                        pcb.setTextMatrix(1.0f, 0.0f, 0.0f, 1.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 270: {
                        pcb.setTextMatrix(0.0f, -1.0f, 1.0f, 0.0f, (float)p1.getX(), (float)p1.getY());
                    }
                }
                break;
            }
            case MirrorLowerLeft: {
                switch (td.getRotation()) {
                    case 0: {
                        pcb.setTextMatrix(0.0f, 1.0f, -1.0f, 0.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 90: {
                        pcb.setTextMatrix(-1.0f, 0.0f, 0.0f, -1.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 180: {
                        pcb.setTextMatrix(0.0f, -1.0f, 1.0f, 0.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 270: {
                        pcb.setTextMatrix(1.0f, 0.0f, 0.0f, 1.0f, (float)p1.getX(), (float)p1.getY());
                    }
                }
                break;
            }
            case MirrorLowerRight: {
                switch (td.getRotation()) {
                    case 0: {
                        pcb.setTextMatrix(0.0f, 1.0f, -1.0f, 0.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 90: {
                        pcb.setTextMatrix(1.0f, 0.0f, 0.0f, 1.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 180: {
                        pcb.setTextMatrix(0.0f, -1.0f, 1.0f, 0.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 270: {
                        pcb.setTextMatrix(-1.0f, 0.0f, 0.0f, -1.0f, (float)p1.getX(), (float)p1.getY());
                    }
                }
                break;
            }
            case MirrorUpperLeft: {
                switch (td.getRotation()) {
                    case 0: {
                        pcb.setTextMatrix(0.0f, -1.0f, 1.0f, 0.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 90: {
                        pcb.setTextMatrix(-1.0f, 0.0f, 0.0f, -1.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 180: {
                        pcb.setTextMatrix(0.0f, 1.0f, -1.0f, 0.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 270: {
                        pcb.setTextMatrix(1.0f, 0.0f, 0.0f, 1.0f, (float)p1.getX(), (float)p1.getY());
                    }
                }
                break;
            }
            case MirrorUpperRight: {
                switch (td.getRotation()) {
                    case 0: {
                        pcb.setTextMatrix(0.0f, -1.0f, 1.0f, 0.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 90: {
                        pcb.setTextMatrix(1.0f, 0.0f, 0.0f, 1.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 180: {
                        pcb.setTextMatrix(0.0f, 1.0f, -1.0f, 0.0f, (float)p1.getX(), (float)p1.getY());
                        break;
                    }
                    case 270: {
                        pcb.setTextMatrix(-1.0f, 0.0f, 0.0f, -1.0f, (float)p1.getX(), (float)p1.getY());
                    }
                }
                break;
            }
            default: {
                pcb.setTextMatrix(1.0f, 0.0f, 0.0f, 1.0f, (float)p1.getX(), (float)p1.getY());
                switch (td.getRotation()) {
                    case 0: {
                        pcb.setTextMatrix(1.0f, 0.0f, 0.0f, 1.0f, (float)p1.getX(), (float)p1.getY());
                        break block0;
                    }
                    case 90: {
                        pcb.setTextMatrix(0.0f, -1.0f, 1.0f, 0.0f, (float)p1.getX(), (float)p1.getY());
                        break block0;
                    }
                    case 180: {
                        pcb.setTextMatrix(-1.0f, 0.0f, 0.0f, -1.0f, (float)p1.getX(), (float)p1.getY());
                        break block0;
                    }
                    case 270: {
                        pcb.setTextMatrix(0.0f, 1.0f, -1.0f, 0.0f, (float)p1.getX(), (float)p1.getY());
                    }
                }
            }
        }
    }

    @Override
    public void setOffset(int x_offset, int y_offset) {
        this.x_offset = x_offset;
        this.y_offset = y_offset;
    }
}

