/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.panels.export;

import java.util.ResourceBundle;
import se.sjobeck.geometra.export.StructuredExport;
import se.sjobeck.geometra.gui.panels.export.Node;
import se.sjobeck.geometra.gui.panels.export.TextExporter;

public class SidaKolumnRadNode
extends Node {
    String namn;
    private final StructuredExport exp;

    protected SidaKolumnRadNode(String namn) {
        this.namn = namn;
        this.exp = new StructuredExport(true, true, true, true, true, true);
    }

    SidaKolumnRadNode(String description, StructuredExport export) {
        this.namn = description;
        this.exp = export;
    }

    @Override
    public int getNbrOfSemiColon() {
        int temp = TextExporter.getInstance().nbrOfSemiColon(this.namn);
        for (Node node : this.vn) {
            if (node.getNbrOfSemiColon() <= temp) continue;
            temp = node.getNbrOfSemiColon();
        }
        return temp;
    }

    @Override
    public String toString(int nbrOfExtraSemiColon) {
        String temp = this.namn;
        for (int i = 0; i < nbrOfExtraSemiColon; ++i) {
            temp = temp + ";";
        }
        temp = temp + ";";
        if (this.exp.shouldExportArea()) {
            temp = temp + ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_AREA") + ";";
        }
        if (this.exp.shouldExportLength()) {
            temp = temp + ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_LENGTH") + ";";
        }
        if (this.exp.shouldExportVolume()) {
            temp = temp + ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_VOLUME") + ";";
        }
        if (this.exp.shouldExportWallArea()) {
            temp = temp + ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_WALL_SURFACE") + ";";
        }
        if (this.exp.shouldExportNumberOfDrawing()) {
            temp = temp + ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_NUMBER_OF_DRAWINGS") + ";";
        }
        if (this.exp.shouldExportHeight()) {
            temp = temp + ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIM_HEIGHT");
        }
        temp = temp + "\n";
        for (Node node : this.vn) {
            temp = temp + node.toString(nbrOfExtraSemiColon);
        }
        return temp;
    }
}

