/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.gui.main;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import se.sjobeck.geometra.datastructures.OpenThread;
import se.sjobeck.geometra.datastructures.blueprint.GeometraManager;
import se.sjobeck.geometra.datastructures.blueprint.ProjectFile;
import se.sjobeck.geometra.datastructures.blueprint.ProjectWorkerListener;
import se.sjobeck.geometra.datastructures.blueprint.TabManager;
import se.sjobeck.geometra.datastructures.blueprint.observer.GeometraSubject;
import se.sjobeck.geometra.export.ExportListener;
import se.sjobeck.geometra.gui.main.Geometra;
import se.sjobeck.geometra.gui.panels.BlueprintTab;
import se.sjobeck.geometra.gui.panels.ButtonPane;
import se.sjobeck.geometra.gui.panels.InfoPanel;
import se.sjobeck.geometra.gui.panels.OptionDialog2;
import se.sjobeck.geometra.gui.panels.ToolbarDimensions2;
import se.sjobeck.geometra.gui.panels.TotalDrawingJPanel;
import se.sjobeck.geometra.gui.panels.TreeTab;

public class GeometraMenu
extends JMenuBar
implements ProjectWorkerListener {
    private ToolbarDimensions2 toolbarDimensions;
    private final GeometraManager geoManager = GeometraManager.getInstance();
    private static final long serialVersionUID = 1L;
    private final TotalDrawingJPanel totalDialog = new TotalDrawingJPanel();
    private ButtonPane buttonPane;
    private final TabManager manager = TabManager.getInstance();
    private String currentFileName;
    private File[] currentFiles;
    private final JMenu options = new JMenu(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("MENU_NAME"));
    private final JMenu viewOption = new JMenu(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("SHOWMENU_NAME"));
    private final JMenuItem saveOptions = new JMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("ADVANCEMENU_ITEM_OPTIONS"));
    private final JMenu advanced = new JMenu(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("ADVANCEDMENU_NAME"));
    private final JMenuItem totalMeasurements = new JMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("ADVANCEMENU_ITEM_TOTAL"));
    private final JDialog scaleDrawingTypeDialog = new JDialog();
    private JComboBox scaleDrawingComboBox;
    private final JRadioButtonMenuItem showAll = new JRadioButtonMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("SHOWMENU_ALL_DIM"));
    private final JRadioButtonMenuItem show2D = new JRadioButtonMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("POPUP_SHOW_2D"));
    private final JRadioButtonMenuItem show3D = new JRadioButtonMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("POPUP_SHOW_3D"));
    private final JRadioButtonMenuItem showNone = new JRadioButtonMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("SHOWMENU_NO_DIM"));
    private final JRadioButtonMenuItem showSpecific = new JRadioButtonMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("SHOWMENU_SPECIFIC_DIM"));
    private final JRadioButtonMenuItem lineDrawingItem = new JRadioButtonMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_LINE"));
    private final JRadioButtonMenuItem squareDrawingItem = new JRadioButtonMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_SQUARE"));
    private final JRadioButtonMenuItem dotDrawingItem = new JRadioButtonMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_DOT"));
    private final JRadioButtonMenuItem smartDrawingItem = new JRadioButtonMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DRAWING_SMART"));
    private final JRadioButtonMenuItem allDrawingItem = new JRadioButtonMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("SHOWMENU_ALL"));
    private final JMenuItem createProject = new JMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("MENU_ITEM_CREATE_PROJECT"));
    private final JMenuItem addPDF = new JMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("MENU_ITEM_ADD_PDF"));
    private final JMenuItem saveProject = new JMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("MENU_ITEM_SAVE_PROJECT"));
    private final JMenuItem saveProjectAs = new JMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("MENU_ITEM_SAVE_PROJECT_AS"));
    private final JMenuItem revision = new JMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("MENU_ITEM_REV_PROJECT"));
    private final JMenuItem closeProject = new JMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("MENU_ITEM_CLOSE_PROJECT"));
    private final JMenuItem terminateProgram = new JMenuItem(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("MENU_ITEM_QUIT"));
    private TreeTab treeTab;
    private final InfoPanel infoPane;
    private BlueprintTab pdfTabs;
    private OptionDialog2 od;
    private final ActionListener mainMenuListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object source = actionEvent.getSource();
            if (!source.equals(GeometraMenu.this.revision)) {
                if (source.equals(GeometraMenu.this.createProject)) {
                    if (GeometraMenu.this.manager.getProjectName() != null) {
                        int ans;
                        int answer = Geometra.createSaveAndLoadDialog(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_CLOSE_PROJECT"));
                        if (answer == 1 && (ans = Geometra.createQuery(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_DO_YOU_WANT_TO_SAVE_PROJECT"))) == 0) {
                            answer = 0;
                        }
                        switch (answer) {
                            case 0: {
                                GeometraMenu.this.saveWork();
                                GeometraSubject.getInstance().disposeAll(this);
                                GeometraMenu.this.treeTab.setProjectName(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TAB_DEFAULT_PROJECT_NAME"));
                                GeometraMenu.this.treeTab.switchFocus();
                                GeometraMenu.this.manager.clearProjectWorker();
                                GeometraMenu.this.buttonPane.disableButtons();
                                GeometraMenu.this.addPDF.setEnabled(false);
                                break;
                            }
                            case 1: {
                                GeometraSubject.getInstance().disposeAll(this);
                                GeometraMenu.this.treeTab.setProjectName(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TAB_DEFAULT_PROJECT_NAME"));
                                GeometraMenu.this.treeTab.switchFocus();
                                GeometraMenu.this.manager.clearProjectWorker();
                                GeometraMenu.this.buttonPane.disableButtons();
                                GeometraMenu.this.addPDF.setEnabled(false);
                                break;
                            }
                            case 2: {
                                return;
                            }
                        }
                    }
                    GeometraMenu.this.currentFileName = GeometraMenu.this.getProjectDialog();
                    while (GeometraMenu.this.geoManager.projectExists(GeometraMenu.this.currentFileName)) {
                        Geometra.createInfoDialog(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_PROJECT_ALREADY_EXIST"));
                        GeometraMenu.this.currentFileName = GeometraMenu.this.getProjectDialog();
                    }
                    if (GeometraMenu.this.currentFileName == null) {
                        return;
                    }
                    GeometraMenu.access$1502(GeometraMenu.this, Geometra.createLoadDialog(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_PICK_PDF_STR")));
                    if (GeometraMenu.this.currentFiles == null || GeometraMenu.this.currentFiles.length == 0) {
                        return;
                    }
                    GeometraMenu.this.openWork();
                    GeometraMenu.this.saveWorkAs();
                    GeometraMenu.this.updateProject();
                    if (GeometraMenu.this.manager.getProjectName() != null) {
                        GeometraMenu.this.treeTab.setProjectName(GeometraMenu.this.manager.getProjectName());
                        GeometraMenu.this.treeTab.switchFocus();
                    }
                } else if (source.equals(GeometraMenu.this.addPDF)) {
                    File[] files = Geometra.createLoadDialog(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_PICK_PDF_STR"));
                    if (files == null || files.length == 0) {
                        return;
                    }
                    GeometraMenu.this.openWork(files);
                } else if (source.equals(GeometraMenu.this.saveProject)) {
                    GeometraMenu.this.saveProject();
                } else if (source.equals(GeometraMenu.this.saveProjectAs)) {
                    GeometraMenu.this.saveProjectAs();
                } else if (source.equals(GeometraMenu.this.closeProject)) {
                    GeometraMenu.this.closeProject();
                } else if (source.equals(GeometraMenu.this.terminateProgram)) {
                    Geometra.shutDownGeometra();
                }
            }
        }
    };
    private final ActionListener dimensionViewListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() instanceof JRadioButtonMenuItem) {
                if (event.getSource().equals(GeometraMenu.this.showAll)) {
                    GeometraMenu.this.manager.setViewingState(BlueprintPage.ViewingState.SHOW_ALL);
                } else if (event.getSource().equals(GeometraMenu.this.show2D)) {
                    GeometraMenu.this.manager.setViewingState(BlueprintPage.ViewingState.SHOW_2D);
                } else if (event.getSource().equals(GeometraMenu.this.show3D)) {
                    GeometraMenu.this.manager.setViewingState(BlueprintPage.ViewingState.SHOW_3D);
                } else if (event.getSource().equals(GeometraMenu.this.showNone)) {
                    GeometraMenu.this.manager.setViewingState(BlueprintPage.ViewingState.SHOW_NONE);
                } else if (event.getSource().equals(GeometraMenu.this.showSpecific)) {
                    GeometraMenu.this.manager.setViewingState(BlueprintPage.ViewingState.SHOW_SPECIFIC);
                }
            }
        }
    };
    private final ActionListener drawingViewListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            TabManager manager = TabManager.getInstance();
            if (event.getSource() instanceof JRadioButtonMenuItem) {
                JRadioButtonMenuItem selectedButton = (JRadioButtonMenuItem)event.getSource();
                if (selectedButton.equals(GeometraMenu.this.lineDrawingItem)) {
                    manager.setDrawingState(BlueprintPage.DrawingState.LINE_DRAWING);
                } else if (selectedButton.equals(GeometraMenu.this.squareDrawingItem)) {
                    manager.setDrawingState(BlueprintPage.DrawingState.SQUARE_DRAWING);
                } else if (selectedButton.equals(GeometraMenu.this.dotDrawingItem)) {
                    manager.setDrawingState(BlueprintPage.DrawingState.DOT_DRAWING);
                } else if (selectedButton.equals(GeometraMenu.this.smartDrawingItem)) {
                    manager.setDrawingState(BlueprintPage.DrawingState.SMART_ONLY);
                } else if (selectedButton.equals(GeometraMenu.this.allDrawingItem)) {
                    manager.setDrawingState(BlueprintPage.DrawingState.NORMAL);
                }
            }
        }
    };

    void setToolbarDimensions(ToolbarDimensions2 toolbarDimensions) {
        this.toolbarDimensions = toolbarDimensions;
    }

    public OptionDialog2 getOptionDialog2() {
        return this.od;
    }

    @Override
    public void thereIsAnActiveProject(ProjectFile pf) {
        if (pf != null) {
            this.addPDF.setEnabled(true);
        } else {
            this.addPDF.setEnabled(false);
        }
    }

    public void enableAddPDFButton() {
        this.addPDF.setEnabled(true);
    }

    public GeometraMenu(InfoPanel infoPane, List<ExportListener> exportListeners, BlueprintTab pdfTabs) {
        this.infoPane = infoPane;
        this.pdfTabs = pdfTabs;
        this.initComponents(exportListeners);
        this.addPDF.setEnabled(false);
        this.manager.setActiveProjectWorkerListener(this);
    }

    protected void setButtonPane(ButtonPane buttonPane) {
        this.buttonPane = buttonPane;
    }

    protected void setTreeTab(TreeTab treeTab) {
        this.treeTab = treeTab;
    }

    private void initComponents(List<ExportListener> exportListeners) {
        this.scaleDrawingComboBox = new JComboBox<ScaleDrawingType>(ScaleDrawingType.values());
        this.scaleDrawingTypeDialog.add(this.scaleDrawingComboBox);
        this.scaleDrawingTypeDialog.pack();
        ButtonGroup drawingGroup = new ButtonGroup();
        ButtonGroup viewGroup = new ButtonGroup();
        drawingGroup.add(this.lineDrawingItem);
        this.lineDrawingItem.addActionListener(this.drawingViewListener);
        drawingGroup.add(this.squareDrawingItem);
        this.squareDrawingItem.addActionListener(this.drawingViewListener);
        drawingGroup.add(this.dotDrawingItem);
        this.dotDrawingItem.addActionListener(this.drawingViewListener);
        drawingGroup.add(this.smartDrawingItem);
        this.smartDrawingItem.addActionListener(this.drawingViewListener);
        drawingGroup.add(this.allDrawingItem);
        this.allDrawingItem.addActionListener(this.drawingViewListener);
        this.allDrawingItem.setSelected(true);
        this.showAll.addActionListener(this.dimensionViewListener);
        viewGroup.add(this.showAll);
        this.show2D.addActionListener(this.dimensionViewListener);
        viewGroup.add(this.show2D);
        this.show3D.addActionListener(this.dimensionViewListener);
        viewGroup.add(this.show3D);
        this.showNone.addActionListener(this.dimensionViewListener);
        viewGroup.add(this.showNone);
        this.showSpecific.addActionListener(this.dimensionViewListener);
        viewGroup.add(this.showSpecific);
        this.showSpecific.setSelected(true);
        this.viewOption.add(this.lineDrawingItem);
        this.viewOption.add(this.squareDrawingItem);
        this.viewOption.add(this.dotDrawingItem);
        this.viewOption.add(this.smartDrawingItem);
        this.viewOption.add(this.allDrawingItem);
        this.viewOption.addSeparator();
        this.viewOption.add(this.showAll);
        this.viewOption.add(this.show2D);
        this.viewOption.add(this.show3D);
        this.viewOption.add(this.showNone);
        this.viewOption.add(this.showSpecific);
        this.od = new OptionDialog2();
        this.od.addExportListener(exportListeners);
        this.od.setIconImage(Geometra.GEOMETRA_FRAME.getIconImage());
        this.saveOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeometraMenu.this.od.setVisible(true);
            }
        });
        this.totalMeasurements.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GeometraMenu.this.totalDialog.setLocationRelativeTo(Geometra.GEOMETRA_FRAME);
                GeometraMenu.this.totalDialog.setVisible(true);
            }
        });
        this.createProject.addActionListener(this.mainMenuListener);
        this.addPDF.addActionListener(this.mainMenuListener);
        this.saveProject.addActionListener(this.mainMenuListener);
        this.saveProjectAs.addActionListener(this.mainMenuListener);
        this.revision.addActionListener(this.mainMenuListener);
        this.closeProject.addActionListener(this.mainMenuListener);
        this.terminateProgram.addActionListener(this.mainMenuListener);
        this.options.add(this.createProject);
        this.options.add(this.addPDF);
        this.options.addSeparator();
        this.options.add(this.saveProject);
        this.options.add(this.saveProjectAs);
        this.options.addSeparator();
        this.options.add(this.closeProject);
        this.options.addSeparator();
        this.options.add(this.terminateProgram);
        this.options.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!TabManager.getInstance().isLastProject()) {
                    GeometraMenu.this.saveProject.setEnabled(false);
                    GeometraMenu.this.saveProjectAs.setEnabled(false);
                    GeometraMenu.this.closeProject.setEnabled(false);
                } else {
                    GeometraMenu.this.saveProject.setEnabled(true);
                    GeometraMenu.this.saveProjectAs.setEnabled(true);
                    GeometraMenu.this.closeProject.setEnabled(true);
                }
            }
        });
        this.advanced.add(this.totalMeasurements);
        this.advanced.add(this.saveOptions);
        this.add(this.options);
        this.add(this.viewOption);
        this.add(this.advanced);
    }

    public void closeProject2() {
        GeometraSubject.getInstance().disposeAll(this);
        this.treeTab.setProjectName(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("TAB_DEFAULT_PROJECT_NAME"));
        this.manager.clearProjectWorker();
        this.buttonPane.disableButtons();
        this.addPDF.setEnabled(false);
    }

    public void closeProject() {
        int ans;
        int answer = Geometra.createSaveAndLoadDialog(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_CLOSE_PROJECT"));
        if (answer == 1 && (ans = Geometra.createQuery(ResourceBundle.getBundle("se/sjobeck/Geometra").getString("DIALOG_DO_YOU_WANT_TO_SAVE_PROJECT"))) == 0) {
            answer = 0;
        }
        switch (answer) {
            case 0: {
                this.saveWork();
                this.closeProject2();
                break;
            }
            case 1: {
                this.closeProject2();
                break;
            }
        }
    }

    public void saveProject() {
        this.saveWork();
    }

    private void saveProjectAs() {
        String temp = this.getProjectDialog();
        if (temp != null) {
            this.currentFileName = temp;
            this.saveWorkAs();
            if (this.manager.getProjectName() != null) {
                this.treeTab.setProjectName(this.manager.getProjectName());
            }
        }
    }

    private void openWork(File[] files) {
        OpenThread thread = new OpenThread(files, this.buttonPane, this.infoPane, this);
        thread.startOpening();
    }

    private void saveWork() {
        System.out.println("sparar projekt knapptryckning");
        String project_name = this.manager.getProjectName();
        if (project_name != null) {
            this.manager.startSaving(this.buttonPane, this.infoPane);
            this.treeTab.changepaths();
        } else {
            this.saveProjectAs();
        }
    }

    private void cleanup() {
        GeometraSubject.getInstance().disposeAll(this);
    }

    private String getProjectDialog() {
        String fileName = Geometra.nameProject();
        if (fileName == null) {
            return null;
        }
        if (fileName.isEmpty()) {
            return null;
        }
        return fileName;
    }

    private void saveWorkAs() {
        try {
            this.manager.startSavingAs(this.currentFileName, this.buttonPane, this.infoPane);
            this.treeTab.changepaths();
        }
        catch (IOException ex) {
            Logger.getLogger(GeometraMenu.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void openWork() {
        this.manager.openPDF(this.currentFiles, this.buttonPane, this.infoPane);
    }

    private void updateProject() {
        this.treeTab.changepaths();
    }

    static /* synthetic */ File[] access$1502(GeometraMenu x0, File[] x1) {
        x0.currentFiles = x1;
        return x1;
    }

    private static enum ScaleDrawingType {
        SCALE("Skala"),
        NORMAL("Normal");

        private String desc;

        private ScaleDrawingType(String str) {
            this.desc = str;
        }

        public String toString() {
            return this.desc;
        }
    }
}

