/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint.observer;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import se.sjobeck.geometra.datastructures.blueprint.observer.Observer;
import se.sjobeck.geometra.datastructures.blueprint.observer.Subject;

public class BlueprintSubject
implements Subject {
    private static BlueprintSubject instance = new BlueprintSubject();
    private final List<Observer> observerList = new CopyOnWriteArrayList<Observer>();

    protected static BlueprintSubject getInstance() {
        return instance;
    }

    private BlueprintSubject() {
    }

    @Override
    public void addObserver(Observer observer) {
        this.observerList.add(observer);
    }

    protected void callAction(Action action, Object ob, Object source) {
        this.notifyObservers(action, ob, source);
    }

    public void notifyObservers(Action action, Object object, Object source) {
        Observer obs = null;
        if (action.equals((Object)Action.REMOVE)) {
            obs = this.observerList.remove(0);
        }
        for (Observer observer : this.observerList) {
            observer.update(action, object, source);
        }
        if (obs != null) {
            this.observerList.add(0, obs);
            obs.update(action, object, source);
        }
    }

    @Override
    public void removeObserver(Observer observer) {
        this.observerList.remove(observer);
    }

    protected void addMainObserver(Observer observer) {
        this.observerList.add(0, observer);
    }

    public static enum Action {
        ADD,
        ADD_SMART_DRAWING,
        ADD_POINT,
        CLOSE,
        REMOVE,
        SELECT,
        UPDATE,
        REPAINT,
        REAL_DISTANCE,
        PAGE_SWITCH,
        SCALEDRAWING_UPDATE,
        LISTENER_SWITCH,
        ZOOM_UPDATE,
        PREPARE_SWITCH,
        DISPOSE_ALL,
        REPLACE,
        UNDO,
        REDO,
        RENAME,
        REMOVE_FROM_SMART,
        ADD_TO_SMART,
        ADD_TO_TOTAL,
        REMOVE_FROM_TOTAL,
        SORT;

    }
}

