/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint.listeners;

import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import se.sjobeck.geometra.datastructures.PaintingStateMachine;
import se.sjobeck.geometra.datastructures.blueprint.PDFController;
import se.sjobeck.geometra.datastructures.blueprint.listeners.GeometraMouseAdapter;

public class FreeMoveListener
extends GeometraMouseAdapter {
    private int startX;
    private int startY;
    private final PaintingStateMachine machine = PaintingStateMachine.getInstance();
    private final PDFController controller;
    private final JViewport viewport;

    public FreeMoveListener(PDFController controller) {
        this.controller = controller;
        JScrollPane viewContainer = (JScrollPane)controller.getViewContainer();
        this.viewport = viewContainer.getViewport();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.machine.setViewCursor(2);
        int maxOffset = 10;
        int minOffset = 0;
        Point currentPosition = this.viewport.getViewPosition();
        int newX = currentPosition.x - (e.getX() - this.startX);
        int newY = currentPosition.y - (e.getY() - this.startY);
        int maxX = (int)this.controller.getDimension().getWidth() - this.viewport.getWidth() + maxOffset;
        int maxY = (int)this.controller.getDimension().getHeight() - this.viewport.getHeight() + maxOffset;
        if (newX < minOffset) {
            newX = minOffset;
        }
        if (newX > maxX) {
            newX = maxX;
        }
        if (newY < minOffset) {
            newY = minOffset;
        }
        if (newY > maxY) {
            newY = maxY;
        }
        if (newX < 0) {
            newX = 0;
        }
        if (newY < 0) {
            newY = 0;
        }
        final Point setPoint = new Point(newX, newY);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FreeMoveListener.this.viewport.setViewPosition(setPoint);
            }
        });
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.viewport.revalidate();
        this.machine.setViewCursor(1);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.machine.setViewCursor(2);
        this.startX = e.getX();
        this.startY = e.getY();
    }
}

