/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.awt.geom.Point2D;
import java.io.Reader;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import org.icepdf.ri.common.views.painting.drawings.ScaleDrawing;
import se.sjobeck.geometra.datastructures.blueprint.BlueprintList;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFBlueprint;
import se.sjobeck.geometra.datastructures.blueprint.IcePDFPage;
import se.sjobeck.geometra.datastructures.core.BlueprintImpl;
import se.sjobeck.geometra.datastructures.core.BlueprintPageImpl;
import se.sjobeck.geometra.datastructures.drawings.DotDrawing;
import se.sjobeck.geometra.datastructures.drawings.DotDrawingContainer;
import se.sjobeck.geometra.datastructures.drawings.GeometraDrawingImpl;
import se.sjobeck.geometra.datastructures.drawings.LineDrawing;
import se.sjobeck.geometra.datastructures.drawings.SmartDrawing;
import se.sjobeck.geometra.datastructures.drawings.SquareDrawing;
import se.sjobeck.geometra.datastructures.drawings.TotalDrawing;
import se.sjobeck.geometra.gui.panels.GeometraColorChooser;
import se.sjobeck.geometra.gui.panels.sun.ProjectColors;
import se.sjobeck.geometra.xstream.ColorConverter;

public class XStreamManager {
    private final XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());

    public BlueprintList getList(Reader reader) {
        BlueprintList bpl = (BlueprintList)this.xstream.fromXML(reader);
        GeometraColorChooser.getInstance().setRecentColors(bpl.getColorsFromDrawings());
        return bpl;
    }

    public XStreamManager() {
        this.xstream.setMode(1004);
        this.xstream.alias("BlueprintList", BlueprintList.class);
        this.xstream.alias("GeometraPDF", IcePDFBlueprint.class);
        this.xstream.alias("GeometraPage", IcePDFPage.class);
        this.xstream.alias("GeometraDrawing", GeometraDrawing.class);
        this.xstream.alias("ScaleDrawing", ScaleDrawing.class);
        this.xstream.alias("SquareDrawing", SquareDrawing.class);
        this.xstream.alias("DotDrawing", DotDrawing.class);
        this.xstream.alias("DotDrawingContainer", DotDrawingContainer.class);
        this.xstream.alias("LineDrawing", LineDrawing.class);
        this.xstream.alias("ProjectColors", ProjectColors.class);
        this.xstream.alias("SmartDrawing", SmartDrawing.class);
        this.xstream.alias("TotalDrawing", TotalDrawing.class);
        this.xstream.alias("Point", Point2D.Double.class);
        this.xstream.alias("Point", Point2D.Float.class);
        this.xstream.useAttributeFor(BlueprintImpl.class, "description");
        this.xstream.useAttributeFor(BlueprintPageImpl.class, "description");
        this.xstream.useAttributeFor(GeometraDrawingImpl.class, "description");
        this.xstream.useAttributeFor(GeometraDrawingImpl.class, "smartColor");
        this.xstream.useAttributeFor(GeometraDrawingImpl.class, "color");
        this.xstream.registerConverter((SingleValueConverter)new ColorConverter());
    }

    public String getString() {
        return this.xstream.toXML((Object)BlueprintList.getInstance());
    }
}

