/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import se.sjobeck.GeometraConfiguration;
import se.sjobeck.geometra.datastructures.blueprint.ProjectFile;
import se.sjobeck.geometra.datastructures.blueprint.ProjectWorkerListener;
import se.sjobeck.geometra.gui.main.Geometra;
import se.sjobeck.geometra.gui.panels.ButtonPane;
import se.sjobeck.geometra.gui.panels.InfoPanel;
import se.sjobeck.geometra.gui.panels.OptionDialog2;
import se.sjobeck.gui.DialogCreator;

final class ProjectWorker {
    private Timer autosaveThread = null;
    public static final int AUTO_SAVE = 0;
    public static final int NORMAL_SAVE = 1;
    public static final int SAVE_AS = 2;
    public static ProjectFile autosaveProject = null;
    public static ProjectFile lastProject = null;
    private boolean isLoaded = false;
    private ProjectWorkerListener pl = null;

    protected ProjectWorker() {
        this.printStatus("ProjektWorker konstruktor");
    }

    private void printStatus(String methodName) {
        String tr\u00e5dnamn = Thread.currentThread().getName();
        String projektnamn = "null";
        if (lastProject != null) {
            projektnamn = lastProject.getLastSaveName();
        }
        System.out.println(tr\u00e5dnamn + ", " + methodName + ", " + projektnamn + ", " + this.isLoaded);
    }

    protected void disposeThread() {
        this.printStatus("disposeThread");
        if (this.autosaveThread == null) {
            return;
        }
        this.autosaveThread.cancel();
        this.autosaveThread = null;
        if (lastProject != null) {
            lastProject.closeProject();
            lastProject = null;
        }
        autosaveProject = null;
        this.doCommunicateChanges(this.pl, lastProject);
    }

    void CancelThread() {
        autosaveProject = null;
        if (this.autosaveThread != null) {
            this.autosaveThread.cancel();
        }
    }

    private void doCommunicateChanges(final ProjectWorkerListener pl, final ProjectFile pf) {
        this.printStatus("doCommunicateChanges");
        if (pl != null) {
            Runnable runnable = new Runnable(){
                ProjectWorkerListener pwl;
                ProjectFile pf_;
                {
                    this.pwl = pl;
                    this.pf_ = pf;
                }

                @Override
                public void run() {
                    if (this.pwl != null) {
                        this.pwl.thereIsAnActiveProject(this.pf_);
                    }
                }
            };
            new Thread(runnable).start();
        }
    }

    protected synchronized void openPDF(ButtonPane buttonPane, InfoPanel infoPane, File ... files) {
        this.printStatus("openPDF");
        if (autosaveProject == null) {
            autosaveProject = new ProjectFile();
            autosaveProject.addButtonPane(buttonPane);
            autosaveProject.addInfoPane(infoPane);
        }
        this.isLoaded = files.length == 1 ? autosaveProject.startLoadingPDFFile(files[0]) : autosaveProject.startLoadingPDFFiles(files);
        if (this.isLoaded) {
            this.startAutosaveProcess();
        }
    }

    protected synchronized boolean isProjectActive() {
        this.printStatus("isProjectActive");
        if (lastProject == null && !this.isLoaded) {
            return false;
        }
        return this.isLoaded;
    }

    protected synchronized void startLoadingProject(File file, ButtonPane buttonPane, InfoPanel infoPane) {
        this.printStatus("startLoadingProject");
        if (lastProject == null) {
            lastProject = new ProjectFile();
        }
        lastProject.addButtonPane(buttonPane);
        lastProject.addInfoPane(infoPane);
        lastProject.startLoadingProjectFile(file, this);
        this.isLoaded = true;
        autosaveProject = lastProject;
        this.doCommunicateChanges(this.pl, lastProject);
    }

    public synchronized void startSaving() {
        this.printStatus("startSaving");
        try {
            lastProject.startSaving();
        }
        catch (Exception e) {
            e.fillInStackTrace().printStackTrace();
            System.out.println(e);
            if (e instanceof IOException) {
                IOException ioe = (IOException)e;
                Throwable cause = ioe.getCause();
                String info = "<html>" + cause.toString() + "<br>" + cause.getMessage() + "<br>";
                for (StackTraceElement st : cause.getStackTrace()) {
                    info = info + st.toString() + "<br>";
                }
                info = info + "</html>";
                DialogCreator.showError(info, "Call support");
            }
            String message = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("ERROR_WHILE_SAVING_STEP1_TEXT");
            String title = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("ERROR_WHILE_SAVING_STEP1_TITLE");
            message = "<html>" + this.insertHTMLTagsAtApropriatePlaces(message, 80) + "</html>";
            JOptionPane.showMessageDialog(Geometra.GEOMETRA_FRAME, message, title, 0);
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(1);
            int showOpenDialog = 1;
            while (showOpenDialog != 0) {
                showOpenDialog = chooser.showOpenDialog(Geometra.GEOMETRA_FRAME);
            }
            File selectedFile = chooser.getSelectedFile();
            try {
                System.out.println("savepath s\u00e4tts till: " + selectedFile.getCanonicalPath());
                String oldpath = GeometraConfiguration.getSavePath();
                GeometraConfiguration.putSavePath(selectedFile.getCanonicalPath());
                OptionDialog2.updateGeometraWithNewSettings();
                this.startSaving();
                String title2 = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("ERROR_WHILE_SAVING_STEP3_TITLE");
                String messagePart1 = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("ERROR_WHILE_SAVING_STEP3_TEXT_PART1");
                String messagePart2 = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("ERROR_WHILE_SAVING_STEP3_TEXT_PART2");
                String messagePart3 = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("ERROR_WHILE_SAVING_STEP3_TEXT_PART3");
                String messagePart4 = ResourceBundle.getBundle("se/sjobeck/Geometra").getString("ERROR_WHILE_SAVING_STEP3_TEXT_PART4");
                String cm = "<html>" + this.insertHTMLTagsAtApropriatePlaces(messagePart1, 80) + "<br> <br> " + selectedFile.getCanonicalPath() + " <br> <br>" + this.insertHTMLTagsAtApropriatePlaces(messagePart2, 80) + "<br> <br>" + oldpath + " <br> <br>" + this.insertHTMLTagsAtApropriatePlaces(messagePart3, 80) + " <br> <br> " + this.insertHTMLTagsAtApropriatePlaces(messagePart4, 80) + "</html>";
                JOptionPane.showMessageDialog(Geometra.GEOMETRA_FRAME, cm, title2, -1);
            }
            catch (IOException ex) {
                Logger.getLogger(ProjectWorker.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(Geometra.GEOMETRA_FRAME, this.getErrorMessageJPanel("An error happened while trying to recover the save process, please try again, if that does not help, please call support"), "Error while trying to recover", -1);
            }
            e.printStackTrace();
        }
    }

    public synchronized boolean isLastProject() {
        return lastProject != null;
    }

    protected synchronized void startSavingAs(String str, ButtonPane buttonPane, InfoPanel infoPane) throws IOException {
        this.printStatus("startSavingAS");
        lastProject = new ProjectFile();
        lastProject.addButtonPane(buttonPane);
        lastProject.addInfoPane(infoPane);
        lastProject.startSaving(str, buttonPane, infoPane, 2);
        this.isLoaded = true;
        autosaveProject = lastProject;
        this.startAutosaveProcess();
        this.doCommunicateChanges(this.pl, lastProject);
    }

    private String insertHTMLTagsAtApropriatePlaces(String in, int rowLength) {
        this.printStatus("insertHTMLTagsAtApropriatePlaces");
        StringBuilder sb = new StringBuilder();
        String[] split = in.split(" ");
        if (split != null) {
            int currentRowLength = 0;
            for (String word : split) {
                if (currentRowLength + 1 + word.length() < rowLength) {
                    sb.append(word + " ");
                    currentRowLength += 1 + word.length();
                    continue;
                }
                currentRowLength = word.length() + 1;
                sb.append(" <br> " + word + " ");
            }
        }
        return sb.toString();
    }

    private JPanel getErrorMessageJPanel(String errorMessage) {
        this.printStatus("getErrorMessageJPanel");
        int rowlength = 80;
        Vector<String> messageRows = new Vector<String>();
        String[] parts = errorMessage.split(" ");
        if (parts != null) {
            StringBuilder sb = new StringBuilder();
            for (String part : parts) {
                if (sb.length() + 1 + part.length() < 80) {
                    sb.append(" " + part);
                    continue;
                }
                messageRows.add(sb.toString());
                sb.delete(0, sb.length());
                if (part.length() < 80) {
                    sb.append(part);
                    continue;
                }
                messageRows.add(part);
            }
            messageRows.add(sb.toString());
        }
        JPanel message = new JPanel(new GridBagLayout());
        int row_grid = 0;
        for (String row : messageRows) {
            GridBagConstraints gbc1 = new GridBagConstraints();
            gbc1.gridx = 0;
            gbc1.gridy = row_grid++;
            gbc1.fill = 1;
            gbc1.weightx = 1.0;
            gbc1.weighty = 1.0;
            JLabel row1 = new JLabel(row);
            message.add((Component)row1, gbc1);
        }
        return message;
    }

    protected synchronized void updateSettings() {
        this.printStatus("updateSettings");
        if (this.autosaveThread != null) {
            this.autosaveThread.cancel();
            this.autosaveThread = null;
        }
        this.startAutosaveProcess();
    }

    public void startAutosaveProcess() {
    }

    synchronized void setActiveProjectWorkerListener(ProjectWorkerListener pl) {
        this.printStatus("setActiveProjectWorkerListener");
        this.pl = pl;
    }

    void clear() {
        autosaveProject = null;
        lastProject = null;
    }

    protected synchronized String getProjectName() {
        this.printStatus("getProjectName");
        if (lastProject != null) {
            return lastProject.getLastSaveName();
        }
        if (autosaveProject != null) {
            return autosaveProject.getLastSaveName();
        }
        return null;
    }

    private class AutosaveProcess
    extends TimerTask {
        private AutosaveProcess() {
        }

        @Override
        public void run() {
            try {
                ProjectWorker.this.printStatus("AutosaveProcess - run - private class");
                if (autosaveProject != null) {
                    autosaveProject.startSaving();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

