/*
 * Decompiled with CFR 0.152.
 */
package se.sjobeck.geometra.datastructures.blueprint;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.icepdf.ri.common.views.painting.core.Blueprint;
import org.icepdf.ri.common.views.painting.core.BlueprintPage;
import org.icepdf.ri.common.views.painting.drawings.GeometraDrawing;
import org.icepdf.ri.common.views.painting.drawings.ScaleDrawing;
import se.sjobeck.geometra.datastructures.drawings.DotDrawing;
import se.sjobeck.geometra.datastructures.drawings.DotDrawingContainer;
import se.sjobeck.geometra.datastructures.drawings.TotalDrawing;
import se.sjobeck.util.SingleItemLinkedList;

public class BlueprintList
implements Iterable<Blueprint>,
Cloneable {
    private static transient BlueprintList instance = new BlueprintList();
    private List<Blueprint> blueprints = Collections.synchronizedList(new ArrayList());
    private final List<TotalDrawing> totalDrawings = Collections.synchronizedList(new ArrayList());

    public Color[] getColorsFromDrawings() {
        int length;
        SingleItemLinkedList sill = new SingleItemLinkedList();
        for (Blueprint bp : this.blueprints) {
            for (int i = 0; i < bp.getNumberOfPages(); ++i) {
                for (GeometraDrawing gd : bp.getPage(i).getDrawings()) {
                    if (gd.getColor() == null || gd instanceof ScaleDrawing) continue;
                    if (gd instanceof DotDrawingContainer) {
                        DotDrawingContainer ddc = (DotDrawingContainer)gd;
                        List<DotDrawing> children = ddc.getChildren();
                        for (DotDrawing dd : children) {
                            sill.add(dd.getColor());
                        }
                    }
                    sill.add(gd.getColor());
                }
            }
        }
        Color[] col = new Color[35];
        for (int i = 0; i < col.length; ++i) {
            col[i] = Color.gray;
        }
        Color[] fromArray = sill.toArray();
        if (fromArray.length < (length = col.length)) {
            length = fromArray.length;
        }
        System.arraycopy(fromArray, 0, col, 0, length);
        return col;
    }

    protected static BlueprintList getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(TotalDrawing tm) {
        if (tm != null) {
            List<TotalDrawing> list = this.totalDrawings;
            synchronized (list) {
                if (!this.totalDrawings.contains(tm)) {
                    this.totalDrawings.add(tm);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(Blueprint ob) {
        if (ob != null) {
            List<Blueprint> list = this.blueprints;
            synchronized (list) {
                if (!this.blueprints.contains(ob)) {
                    this.blueprints.add(ob);
                }
            }
        }
    }

    private BlueprintList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(Blueprint bp) {
        ArrayList<TotalDrawing> toBeRemoved = new ArrayList<TotalDrawing>();
        ArrayList<GeometraDrawing> gdRemove = new ArrayList<GeometraDrawing>();
        List<Object> list = this.totalDrawings;
        synchronized (list) {
            for (TotalDrawing td : this.totalDrawings) {
                for (int i = 0; i < td.size(); ++i) {
                    Blueprint parent1;
                    GeometraDrawing gd = td.getChild(i);
                    BlueprintPage parent = gd.getParent();
                    if (parent == null || !(parent1 = parent.getParent()).equals(bp)) continue;
                    gdRemove.add(gd);
                }
                for (GeometraDrawing gd : gdRemove) {
                    td.removeDrawing(gd);
                }
                if (td.size() != 0) continue;
                toBeRemoved.add(td);
            }
            this.totalDrawings.removeAll(toBeRemoved);
        }
        list = this.blueprints;
        synchronized (list) {
            this.blueprints.remove(bp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(TotalDrawing tm) {
        List<TotalDrawing> list = this.totalDrawings;
        synchronized (list) {
            this.totalDrawings.remove(tm);
        }
    }

    public void sort(int sortType, Object ob) {
        if (ob != null) {
            if (ob instanceof Blueprint) {
                Blueprint bp = (Blueprint)ob;
                bp.sort(sortType);
            } else if (ob instanceof BlueprintPage) {
                BlueprintPage page = (BlueprintPage)ob;
                page.sort(sortType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        List<Blueprint> list = this.blueprints;
        synchronized (list) {
            return this.blueprints.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int totalDrawingSize() {
        List<TotalDrawing> list = this.totalDrawings;
        synchronized (list) {
            return this.totalDrawings.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlueprintList clone() {
        BlueprintList copy = null;
        try {
            copy = (BlueprintList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        List<Blueprint> list = this.blueprints;
        synchronized (list) {
            copy.blueprints = Collections.synchronizedList(new ArrayList(this.blueprints.size()));
            Collections.copy(copy.blueprints, this.blueprints);
            return copy;
        }
    }

    private boolean totalDrawingsContains(String str) {
        for (TotalDrawing td : this.totalDrawings) {
            if (!td.getDescription().equals(str)) continue;
            return true;
        }
        return false;
    }

    protected String getValidName(String tdName) {
        String newString = tdName;
        int it = 1;
        while (this.totalDrawingsContains(newString)) {
            String testString = "(" + it + ")";
            if (newString.contains(testString)) {
                newString = newString.replace(testString, "");
                ++it;
            }
            newString = newString + "(" + it + ")";
        }
        return newString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TotalDrawing getTotalDrawing(int index) {
        List<TotalDrawing> list = this.totalDrawings;
        synchronized (list) {
            return this.totalDrawings.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Blueprint getBlueprint(int index) {
        List<Blueprint> list = this.blueprints;
        synchronized (list) {
            return this.blueprints.get(index);
        }
    }

    @Override
    public final Iterator<Blueprint> iterator() {
        return this.blueprints.iterator();
    }
}

